"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectInferenceId = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _lib = require("../../../lib");
var _app_context = require("../../../../../app_context");
var _api = require("../../../../../services/api");
var _shared_imports = require("../../../shared_imports");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const InferenceFlyoutWrapper = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/inference-endpoint-ui-common'))));
const SelectInferenceId = ({
  'data-test-subj': dataTestSubj
}) => {
  const config = (0, _lib.getFieldConfig)('inference_id');
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "inference_id",
    fieldConfig: config
  }, field => {
    return /*#__PURE__*/_react.default.createElement(SelectInferenceIdContent, {
      "data-test-subj": dataTestSubj,
      value: field.value,
      setValue: field.setValue
    });
  });
};
exports.SelectInferenceId = SelectInferenceId;
const SelectInferenceIdContent = ({
  'data-test-subj': dataTestSubj,
  setValue,
  value
}) => {
  var _share$url$locators$g, _options$find;
  const {
    core: {
      application,
      http
    },
    services: {
      notificationService: {
        toasts
      }
    },
    docLinks,
    plugins: {
      share
    }
  } = (0, _app_context.useAppContext)();
  const config = (0, _lib.getFieldConfig)('inference_id');
  const inferenceEndpointsPageLink = share === null || share === void 0 ? void 0 : (_share$url$locators$g = share.url.locators.get('SEARCH_INFERENCE_ENDPOINTS')) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.useUrl({});
  const [isInferenceFlyoutVisible, setIsInferenceFlyoutVisible] = (0, _react.useState)(false);
  const onFlyoutClose = (0, _react.useCallback)(() => {
    setIsInferenceFlyoutVisible(!isInferenceFlyoutVisible);
  }, [isInferenceFlyoutVisible]);
  const {
    isLoading,
    data: endpoints,
    resendRequest
  } = (0, _api.useLoadInferenceEndpoints)();
  const onSubmitSuccess = (0, _react.useCallback)(newEndpointId => {
    resendRequest();
    setValue(newEndpointId);
  }, [resendRequest, setValue]);
  const options = (0, _react.useMemo)(() => {
    const filteredEndpoints = endpoints === null || endpoints === void 0 ? void 0 : endpoints.filter(endpoint => endpoint.task_type === 'text_embedding' || endpoint.task_type === 'sparse_embedding');
    const newOptions = [...(filteredEndpoints || [])].map(endpoint => ({
      label: endpoint.inference_id,
      'data-test-subj': `custom-inference_${endpoint.inference_id}`,
      checked: value === endpoint.inference_id ? 'on' : undefined
    }));
    /**
     * Adding this check to ensure we have the preconfigured elser endpoint selected by default.
     */
    const hasInferenceSelected = newOptions.some(option => option.checked === 'on');
    if (!hasInferenceSelected && newOptions.length > 0) {
      newOptions[0].checked = 'on';
    }
    if (value && !newOptions.find(option => option.label === value)) {
      // Sometimes we create a new endpoint but the backend is slow in updating so we need to optimistically update
      const newOption = {
        label: value,
        checked: 'on',
        'data-test-subj': `custom-inference_${value}`
      };
      return [...newOptions, newOption];
    }
    return newOptions;
  }, [endpoints, value]);
  const [isInferencePopoverVisible, setIsInferencePopoverVisible] = (0, _react.useState)(false);
  const selectedOptionLabel = (_options$find = options.find(option => option.checked)) === null || _options$find === void 0 ? void 0 : _options$find.label;
  const inferencePopover = () => /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, config.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "arrowDown",
      iconSide: "right",
      color: "text",
      "data-test-subj": "inferenceIdButton",
      onClick: () => {
        setIsInferencePopoverVisible(!isInferencePopoverVisible);
      }
    }, selectedOptionLabel || _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.alreadyExistsLabel', {
      defaultMessage: 'No inference endpoint selected'
    }))),
    isOpen: isInferencePopoverVisible,
    panelPaddingSize: "none",
    closePopover: () => setIsInferencePopoverVisible(!isInferencePopoverVisible)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "createInferenceEndpointButton",
    icon: "plusInCircle",
    size: "s",
    "data-test-subj": "createInferenceEndpointButton",
    onClick: e => {
      e.preventDefault();
      setIsInferenceFlyoutVisible(true);
      setIsInferencePopoverVisible(!isInferencePopoverVisible);
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.createInferenceEndpointButton', {
    defaultMessage: 'Add inference endpoint'
  })), inferenceEndpointsPageLink && /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "manageInferenceEndpointButton",
    icon: "gear",
    size: "s",
    "data-test-subj": "manageInferenceEndpointButton",
    href: inferenceEndpointsPageLink,
    onClick: e => {
      e.preventDefault();
      application.navigateToUrl(inferenceEndpointsPageLink);
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.manageInferenceEndpointButton', {
    defaultMessage: 'Manage Inference Endpoints'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.Label', {
      defaultMessage: 'Existing endpoints'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.ariaLabel', {
      defaultMessage: 'Existing endpoints'
    }),
    "data-test-subj": dataTestSubj,
    searchable: true,
    isLoading: isLoading,
    singleSelection: "always",
    defaultChecked: true,
    searchProps: {
      compressed: true,
      placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.placeholder', {
        defaultMessage: 'Search'
      })
    },
    options: options,
    onChange: newOptions => {
      var _newOptions$find;
      setValue(((_newOptions$find = newOptions.find(option => option.checked)) === null || _newOptions$find === void 0 ? void 0 : _newOptions$find.label) || '');
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), list))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "help",
      color: "primary"
    }),
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.inferenceManagement.inferenceAPIDocumentation,
    target: "_blank",
    "data-test-subj": "learn-how-to-create-inference-endpoints"
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.learnHowToCreateInferenceEndpoints', {
    defaultMessage: 'Learn how to create inference endpoints'
  }))));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "selectInferenceId",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, inferencePopover(), isInferenceFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l"
    })
  }, /*#__PURE__*/_react.default.createElement(InferenceFlyoutWrapper, {
    onFlyoutClose: onFlyoutClose,
    http: http,
    toasts: toasts,
    isEdit: false,
    onSubmitSuccess: onSubmitSuccess
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.noReferenceModelStartWarningMessage', {
    defaultMessage: 'The referenced model for this inference endpoint will be started when adding this field.'
  })))))));
};