"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhaseIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const phaseToIndicatorColors = {
  hot: _uiTheme.euiThemeVars.euiColorVis9,
  warm: _uiTheme.euiThemeVars.euiColorVis5,
  cold: _uiTheme.euiThemeVars.euiColorVis1,
  frozen: _uiTheme.euiThemeVars.euiColorVis4,
  delete: _uiTheme.euiThemeVars.euiColorLightShade
};
const PhaseIndicator = ({
  phase
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        width: 16px;
        height: 8px;
        display: inline-block;
        border-radius: 4px;
        background-color: ${phaseToIndicatorColors[phase]};
      `
  });
};
exports.PhaseIndicator = PhaseIndicator;