"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  // List of data streams
  router.versioned.get({
    path: _constants2.DATA_STREAM_API_ROUTES.LIST_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    },
    summary: `Get data streams`,
    options: {
      tags: ['oas-tag:Data streams']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: false
  }, _handlers.getListHandler);
};
exports.registerRoutes = registerRoutes;