"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeferredAssetsSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../../../hooks");
var _types = require("../../../../../types");
var _deferred_assets_warning = require("./deferred_assets_warning");
var _deferred_transforms_accordion = require("./deferred_transforms_accordion");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeferredAssetsSection = ({
  deferredInstallations,
  packageInfo,
  forceRefreshAssets
}) => {
  const authz = (0, _hooks.useAuthz)();
  const deferredTransforms = deferredInstallations.filter(asset => asset.type === _types.ElasticsearchAssetType.transform);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.assets.deferredInstallationsLabel",
    defaultMessage: "Deferred installations"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    color: "warning",
    iconType: "alert",
    title: (0, _deferred_assets_warning.getDeferredInstallationMsg)(deferredInstallations.length, {
      authz
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_deferred_transforms_accordion.DeferredTransformAccordion, {
    packageInfo: packageInfo,
    type: _types.ElasticsearchAssetType.transform,
    deferredInstallations: deferredTransforms,
    forceRefreshAssets: forceRefreshAssets
  }));
};
exports.DeferredAssetsSection = DeferredAssetsSection;