"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActivityItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _view_errors = require("../view_errors");
var _helpers = require("./helpers");
var _view_agents_button = require("./view_agents_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActivityItem = ({
  action,
  onClickViewAgents
}) => {
  const completeTitle = action.type === 'POLICY_CHANGE' && action.nbAgentsActioned === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivity.policyChangeCompletedTitle",
    defaultMessage: "Policy changed"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivity.completedTitle",
    defaultMessage: "{nbAgents} {agents} {completedText}{offlineText}",
    values: {
      nbAgents: action.nbAgentsAck === action.nbAgentsActioned ? action.nbAgentsAck : action.nbAgentsAck + ' of ' + action.nbAgentsActioned,
      agents: action.nbAgentsActioned === 1 ? 'agent' : 'agents',
      completedText: (0, _helpers.getAction)(action.type, action.actionId).completedText,
      offlineText: action.status === 'ROLLOUT_PASSED' && action.nbAgentsActioned - action.nbAgentsAck > 0 ? `, ${action.nbAgentsActioned - action.nbAgentsAck} agent(s) offline during the rollout period` : ''
    }
  }));

  // TODO: investigate whether default completion is due to a bug
  const completedDescription = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.completedDescription",
    defaultMessage: "Completed {date}",
    values: {
      date: action.completionTime === '0001-01-01T00:00:00.000Z' ? null : (0, _helpers.formattedTime)(action.completionTime)
    }
  });
  const failedDescription = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.failureDescription",
    defaultMessage: "A problem occurred during this operation."
  }), "\xA0", (0, _helpers.inProgressDescription)(action.creationTime)));
  const displayByStatus = {
    IN_PROGRESS: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m"
      }),
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, (0, _helpers.inProgressTitle)(action)),
      titleColor: _helpers.inProgressTitleColor,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, (0, _helpers.inProgressDescription)(action.creationTime))
    },
    ROLLOUT_PASSED: {
      icon: action.nbAgentsFailed > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "warning",
        color: "red"
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "checkInCircleFilled",
        color: "green"
      }),
      title: completeTitle,
      titleColor: action.nbAgentsFailed > 0 ? 'red' : 'green',
      description: action.nbAgentsFailed > 0 ? failedDescription : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, completedDescription)
    },
    COMPLETE: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "checkInCircleFilled",
        color: "green"
      }),
      title: completeTitle,
      titleColor: 'green',
      description: action.type === 'POLICY_REASSIGN' && action.newPolicyId ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.reassignCompletedDescription",
        defaultMessage: "Assigned to {policy}.",
        values: {
          policy: action.newPolicyId
        }
      }), ' ', completedDescription)) : action.type === 'POLICY_CHANGE' ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("b", null, action.policyId), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.policyChangedDescription",
        defaultMessage: "changed to revision {rev} at {date}.",
        values: {
          rev: action.revision,
          date: (0, _helpers.formattedTime)(action.creationTime)
        }
      }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, completedDescription)
    },
    FAILED: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "warning",
        color: "red"
      }),
      title: completeTitle,
      titleColor: 'red',
      description: failedDescription
    },
    CANCELLED: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "warning",
        color: "grey"
      }),
      titleColor: 'grey',
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.cancelledTitle",
        defaultMessage: "Agent {cancelledText} cancelled",
        values: {
          cancelledText: (0, _helpers.getAction)(action.type, action.actionId).cancelledText
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.cancelledDescription",
        defaultMessage: "Cancelled on {date}",
        values: {
          date: (0, _helpers.formattedTime)(action.cancellationTime)
        }
      }))
    },
    EXPIRED: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "warning",
        color: "grey"
      }),
      titleColor: 'grey',
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.expiredTitle",
        defaultMessage: "Agent {expiredText} expired",
        values: {
          expiredText: (0, _helpers.getAction)(action.type, action.actionId).cancelledText
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.expiredDescription",
        defaultMessage: "Expired on {date}",
        values: {
          date: (0, _helpers.formattedTime)(action.expiration)
        }
      }))
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    borderRadius: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, displayByStatus[action.status].icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: displayByStatus[action.status].titleColor,
    "data-test-subj": "statusTitle"
  }, displayByStatus[action.status].title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "statusDescription"
  }, displayByStatus[action.status].description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, action.status === 'FAILED' && action.latestErrors && action.latestErrors.length > 0 ? /*#__PURE__*/_react.default.createElement(_view_errors.ViewErrors, {
    action: action
  }) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_view_agents_button.ViewAgentsButton, {
    action: action,
    onClickViewAgents: onClickViewAgents
  }));
};
exports.ActivityItem = ActivityItem;