"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepsWithLessPadding = exports.CreatePackagePolicySinglePage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_space_settings_context = require("../../../../../../hooks/use_space_settings_context");
var _constants = require("../../../../../../../common/constants");
var _transform_install_as_current_user_callout = require("../../../../../../components/transform_install_as_current_user_callout");
var _hooks = require("../hooks");
var _services = require("../../../../../../../common/services");
var _types = require("../../../../types");
var _hooks2 = require("../../../../hooks");
var _components = require("../../../../components");
var _components2 = require("../../components");
var _services2 = require("../../../../services");
var _components3 = require("../components");
var _generate_new_agent_policy = require("../../../../../../../common/services/generate_new_agent_policy");
var _utils = require("../utils");
var _components4 = require("./components");
var _hooks3 = require("./hooks");
var _post_install_cloud_formation_modal = require("./components/cloud_security_posture/post_install_cloud_formation_modal");
var _post_install_google_cloud_shell_modal = require("./components/cloud_security_posture/post_install_google_cloud_shell_modal");
var _post_install_azure_arm_template_modal = require("./components/cloud_security_posture/post_install_azure_arm_template_modal");
var _root_callout = require("./root_callout");
var _setup_technology_selector = require("./components/setup_technology_selector");
var _setup_technology = require("./hooks/setup_technology");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepsWithLessPadding = exports.StepsWithLessPadding = (0, _styledComponents.default)(_eui.EuiSteps)`
  .euiStep__content {
    padding-bottom: ${props => props.theme.eui.euiSizeM};
  }

  // compensating for EuiBottomBar hiding the content
  @media (max-width: ${props => props.theme.eui.euiBreakpoints.m}) {
    margin-bottom: 100px;
  }
`;
const CustomEuiBottomBar = (0, _styledComponents.default)(_eui.EuiBottomBar)`
  /* A relatively _low_ z-index value here to account for EuiComboBox popover that might appear under the bottom bar */
  z-index: 50;
`;
const CreatePackagePolicySinglePage = ({
  from,
  queryParamsPolicyId,
  prerelease
}) => {
  var _packagePolicy$packag, _packagePolicy$packag2, _packagePolicy$packag3, _packagePolicy$packag4, _packageInfo$name;
  const {
    agents: {
      enabled: isFleetEnabled
    }
  } = (0, _hooks2.useConfig)();
  const hasFleetAddAgentsPrivileges = (0, _hooks2.useAuthz)().fleet.addAgents;
  const {
    params
  } = (0, _reactRouterDom.useRouteMatch)();
  const fleetStatus = (0, _hooks2.useFleetStatus)();
  const {
    docLinks
  } = (0, _hooks2.useStartServices)();
  const spaceSettings = (0, _use_space_settings_context.useSpaceSettingsContext)();
  const [newAgentPolicy, setNewAgentPolicy] = (0, _react.useState)((0, _generate_new_agent_policy.generateNewAgentPolicyWithDefaults)({
    name: 'Agent policy 1',
    namespace: spaceSettings.defaultNamespace
  }));
  const [withSysMonitoring, setWithSysMonitoring] = (0, _react.useState)(true);
  const validation = (0, _components2.agentPolicyFormValidation)(newAgentPolicy, {
    allowedNamespacePrefixes: spaceSettings.allowedNamespacePrefixes
  });
  const [selectedPolicyTab, setSelectedPolicyTab] = (0, _react.useState)(queryParamsPolicyId ? _components3.SelectedPolicyTab.EXISTING : _components3.SelectedPolicyTab.NEW);
  const {
    pkgName,
    pkgVersion
  } = (0, _services.splitPkgKey)(params.pkgkey);
  // Fetch package info
  const {
    data: packageInfoData,
    error: packageInfoError,
    isLoading: isPackageInfoLoading
  } = (0, _hooks2.useGetPackageInfoByKeyQuery)(pkgName, pkgVersion, {
    full: true,
    prerelease
  });
  const packageInfo = (0, _react.useMemo)(() => {
    if (packageInfoData && packageInfoData.item) {
      return packageInfoData.item;
    }
  }, [packageInfoData]);
  const [agentCount, setAgentCount] = (0, _react.useState)(0);
  const [integrationToEnable, setIntegrationToEnable] = (0, _react.useState)(params.integration);
  const integrationInfo = (0, _react.useMemo)(() => {
    var _packageInfo$policy_t;
    return integrationToEnable ? packageInfo === null || packageInfo === void 0 ? void 0 : (_packageInfo$policy_t = packageInfo.policy_templates) === null || _packageInfo$policy_t === void 0 ? void 0 : _packageInfo$policy_t.find(policyTemplate => policyTemplate.name === integrationToEnable) : undefined;
  }, [integrationToEnable, packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.policy_templates]);
  const showSecretsDisabledCallout = !fleetStatus.isSecretsStorageEnabled && packageInfo && (0, _utils.packageHasAtLeastOneSecret)({
    packageInfo
  });

  // Save package policy
  const {
    onSubmit,
    updatePackagePolicy,
    packagePolicy,
    agentPolicies,
    updateAgentPolicies,
    savedPackagePolicy,
    formState,
    setFormState,
    navigateAddAgent,
    navigateAddAgentHelp,
    setHasAgentPolicyError,
    validationResults,
    hasAgentPolicyError,
    isInitialized,
    handleSetupTechnologyChange,
    allowedSetupTechnologies,
    selectedSetupTechnology,
    defaultSetupTechnology,
    isAgentlessSelected
  } = (0, _hooks3.useOnSubmit)({
    agentCount,
    packageInfo,
    newAgentPolicy,
    selectedPolicyTab,
    withSysMonitoring,
    queryParamsPolicyId,
    integrationToEnable,
    hasFleetAddAgentsPrivileges,
    setNewAgentPolicy,
    setSelectedPolicyTab
  });
  const setPolicyValidation = (0, _react.useCallback)((selectedTab, updatedAgentPolicy) => {
    if (selectedTab === _components3.SelectedPolicyTab.NEW) {
      if (!updatedAgentPolicy.name || updatedAgentPolicy.name.trim() === '' || !updatedAgentPolicy.namespace || updatedAgentPolicy.namespace.trim() === '') {
        setHasAgentPolicyError(true);
      } else {
        setHasAgentPolicyError(false);
      }
    }
  }, [setHasAgentPolicyError]);
  const updateNewAgentPolicy = (0, _react.useCallback)(updatedFields => {
    const updatedAgentPolicy = {
      ...newAgentPolicy,
      ...updatedFields
    };
    setNewAgentPolicy(updatedAgentPolicy);
    setPolicyValidation(selectedPolicyTab, updatedAgentPolicy);
  }, [setNewAgentPolicy, setPolicyValidation, newAgentPolicy, selectedPolicyTab]);
  const updateSelectedPolicyTab = (0, _react.useCallback)(selectedTab => {
    setSelectedPolicyTab(selectedTab);
    setPolicyValidation(selectedTab, newAgentPolicy);
  }, [setSelectedPolicyTab, setPolicyValidation, newAgentPolicy]);

  // Retrieve agent count
  const agentPolicyIds = agentPolicies.map(policy => policy.id);
  const {
    cancelClickHandler,
    cancelUrl
  } = (0, _hooks.useCancelAddPackagePolicy)({
    from,
    pkgkey: params.pkgkey,
    agentPolicyId: agentPolicyIds[0]
  });
  (0, _react.useEffect)(() => {
    const getAgentCount = async () => {
      let count = 0;
      for (const policyId of agentPolicyIds) {
        const {
          data
        } = await (0, _hooks2.sendGetAgentStatus)({
          policyId
        });
        if (data !== null && data !== void 0 && data.results.total) {
          count += data.results.total;
        }
      }
      setAgentCount(count);
    };
    if (selectedPolicyTab === _components3.SelectedPolicyTab.NEW) {
      setAgentCount(0);
      return;
    }
    if (isFleetEnabled && agentPolicyIds.length > 0) {
      getAgentCount();
    }
  }, [agentPolicyIds, selectedPolicyTab, isFleetEnabled]);
  const handleExtensionViewOnChange = (0, _react.useCallback)(({
    isValid,
    updatedPolicy
  }) => {
    updatePackagePolicy(updatedPolicy);
    setFormState(prevState => {
      if (prevState === 'VALID' && !isValid) {
        return 'INVALID';
      }
      return prevState;
    });
  }, [updatePackagePolicy, setFormState]);
  const {
    devtoolRequest,
    devtoolRequestDescription,
    showDevtoolsRequest
  } = (0, _hooks3.useDevToolsRequest)({
    newAgentPolicy,
    packagePolicy,
    selectedPolicyTab,
    withSysMonitoring,
    packageInfo
  });
  const layoutProps = (0, _react.useMemo)(() => ({
    from,
    cancelUrl,
    onCancel: cancelClickHandler,
    agentPolicies,
    packageInfo,
    integrationInfo
  }), [agentPolicies, cancelClickHandler, cancelUrl, from, integrationInfo, packageInfo]);
  const stepSelectAgentPolicy = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_components3.StepSelectHosts, {
    agentPolicies: agentPolicies,
    updateAgentPolicies: updateAgentPolicies,
    newAgentPolicy: newAgentPolicy,
    updateNewAgentPolicy: updateNewAgentPolicy,
    withSysMonitoring: withSysMonitoring,
    updateSysMonitoring: newValue => setWithSysMonitoring(newValue),
    validation: validation,
    packageInfo: packageInfo,
    setHasAgentPolicyError: setHasAgentPolicyError,
    updateSelectedTab: updateSelectedPolicyTab,
    selectedAgentPolicyIds: queryParamsPolicyId ? [queryParamsPolicyId] : []
  }), [packageInfo, agentPolicies, updateAgentPolicies, newAgentPolicy, updateNewAgentPolicy, validation, withSysMonitoring, updateSelectedPolicyTab, queryParamsPolicyId, setHasAgentPolicyError]);
  const numTransformAssets = (0, _react.useMemo)(() => (0, _transform_install_as_current_user_callout.getNumTransformAssets)(packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.assets), [packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.assets]);
  const extensionView = (0, _hooks2.useUIExtension)((_packagePolicy$packag = (_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.name) !== null && _packagePolicy$packag !== void 0 ? _packagePolicy$packag : '', 'package-policy-create');
  const replaceDefineStepView = (0, _hooks2.useUIExtension)((_packagePolicy$packag3 = (_packagePolicy$packag4 = packagePolicy.package) === null || _packagePolicy$packag4 === void 0 ? void 0 : _packagePolicy$packag4.name) !== null && _packagePolicy$packag3 !== void 0 ? _packagePolicy$packag3 : '', 'package-policy-replace-define-step');

  // PLI auth blocks are registered to UI Extension context and are used to display upselling components.
  // Upselling components are rendered conditionally based on their availability from the PLI upselling service.
  const pliAuthBlockView = (0, _hooks2.useUIExtension)((_packageInfo$name = packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name) !== null && _packageInfo$name !== void 0 ? _packageInfo$name : '', 'pli-auth-block');

  // If an auth block view is registered to the UI Extension context, we expect the registered component to return a React component when the PLI is not sufficient,
  // or simply a wrapper returning the children if the PLI is sufficient.
  const PliAuthBlockWrapper = (0, _react.useMemo)(() => pliAuthBlockView !== null && pliAuthBlockView !== void 0 && pliAuthBlockView.Component && !isPackageInfoLoading ? pliAuthBlockView.Component : ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children),
  // when no UI Extension is registered, render children
  [isPackageInfoLoading, pliAuthBlockView === null || pliAuthBlockView === void 0 ? void 0 : pliAuthBlockView.Component]);
  if (replaceDefineStepView && extensionView) {
    throw new Error("'package-policy-create' and 'package-policy-replace-define-step' cannot both be registered as UI extensions");
  }
  const {
    isAgentlessIntegration
  } = (0, _setup_technology.useAgentless)();
  const replaceStepConfigurePackagePolicy = replaceDefineStepView && packageInfo !== null && packageInfo !== void 0 && packageInfo.name ? !isInitialized ? /*#__PURE__*/_react.default.createElement(_components.Loading, null) : /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, null, /*#__PURE__*/_react.default.createElement(replaceDefineStepView.Component, {
    agentPolicies: agentPolicies,
    packageInfo: packageInfo,
    newPolicy: packagePolicy,
    onChange: handleExtensionViewOnChange,
    validationResults: validationResults,
    isEditPage: false,
    handleSetupTechnologyChange: handleSetupTechnologyChange,
    isAgentlessEnabled: isAgentlessIntegration(packageInfo),
    defaultSetupTechnology: defaultSetupTechnology,
    integrationToEnable: integrationToEnable,
    setIntegrationToEnable: setIntegrationToEnable
  })) : undefined;
  const stepConfigurePackagePolicy = (0, _react.useMemo)(() => {
    var _spaceSettings$allowe, _packagePolicy$packag5;
    return isPackageInfoLoading || !isInitialized ? /*#__PURE__*/_react.default.createElement(_components.Loading, null) : packageInfo ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components3.StepDefinePackagePolicy, {
      namespacePlaceholder: (0, _services.getInheritedNamespace)(agentPolicies, spaceSettings === null || spaceSettings === void 0 ? void 0 : (_spaceSettings$allowe = spaceSettings.allowedNamespacePrefixes) === null || _spaceSettings$allowe === void 0 ? void 0 : _spaceSettings$allowe[0]),
      packageInfo: packageInfo,
      packagePolicy: packagePolicy,
      updatePackagePolicy: updatePackagePolicy,
      validationResults: validationResults,
      submitAttempted: formState === 'INVALID'
    }), !extensionView && isAgentlessIntegration(packageInfo) && /*#__PURE__*/_react.default.createElement(_setup_technology_selector.SetupTechnologySelector, {
      disabled: false,
      allowedSetupTechnologies: allowedSetupTechnologies,
      setupTechnology: selectedSetupTechnology,
      onSetupTechnologyChange: value => {
        handleSetupTechnologyChange(value);
        // agentless doesn't need system integration
        setWithSysMonitoring(value === _types.SetupTechnology.AGENT_BASED);
      }
    }), !extensionView && /*#__PURE__*/_react.default.createElement(_components3.StepConfigurePackagePolicy, {
      packageInfo: packageInfo,
      showOnlyIntegration: integrationToEnable,
      packagePolicy: packagePolicy,
      updatePackagePolicy: updatePackagePolicy,
      validationResults: validationResults,
      submitAttempted: formState === 'INVALID',
      isAgentlessSelected: isAgentlessSelected
    }), extensionView && ((_packagePolicy$packag5 = packagePolicy.package) === null || _packagePolicy$packag5 === void 0 ? void 0 : _packagePolicy$packag5.name) && /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, null, /*#__PURE__*/_react.default.createElement(extensionView.Component, {
      newPolicy: packagePolicy,
      onChange: handleExtensionViewOnChange
    }))) : /*#__PURE__*/_react.default.createElement("div", null);
  }, [isPackageInfoLoading, isInitialized, packageInfo, agentPolicies, spaceSettings === null || spaceSettings === void 0 ? void 0 : spaceSettings.allowedNamespacePrefixes, packagePolicy, updatePackagePolicy, validationResults, formState, extensionView, isAgentlessIntegration, selectedSetupTechnology, integrationToEnable, isAgentlessSelected, handleExtensionViewOnChange, handleSetupTechnologyChange, allowedSetupTechnologies]);
  const steps = [{
    title: _i18n.i18n.translate('xpack.fleet.createPackagePolicy.stepConfigurePackagePolicyTitle', {
      defaultMessage: 'Configure integration'
    }),
    'data-test-subj': 'dataCollectionSetupStep',
    children: replaceStepConfigurePackagePolicy || stepConfigurePackagePolicy,
    headingElement: 'h2'
  }, ...(selectedSetupTechnology !== _types.SetupTechnology.AGENTLESS ? [{
    title: _i18n.i18n.translate('xpack.fleet.createPackagePolicy.stepSelectAgentPolicyTitle', {
      defaultMessage: 'Where to add this integration?'
    }),
    children: stepSelectAgentPolicy,
    headingElement: 'h2'
  }] : [])];

  // Display package error if there is one
  if (packageInfoError) {
    return /*#__PURE__*/_react.default.createElement(_components.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.errorLoadingPackageTitle",
        defaultMessage: "Error loading package information"
      }),
      error: packageInfoError
    });
  }
  const rootPrivilegedDataStreams = packageInfo ? (0, _services.getRootPrivilegedDataStreams)(packageInfo) : [];
  return /*#__PURE__*/_react.default.createElement(_components4.CreatePackagePolicySinglePageLayout, (0, _extends2.default)({}, layoutProps, {
    "data-test-subj": "createPackagePolicy"
  }), /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_components.Loading, null)
  }, /*#__PURE__*/_react.default.createElement(PliAuthBlockWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, formState === 'CONFIRM' && /*#__PURE__*/_react.default.createElement(_components2.ConfirmDeployAgentPolicyModal, {
    agentCount: agentCount,
    agentPolicies: agentPolicies,
    onConfirm: onSubmit,
    onCancel: () => setFormState('VALID')
  }), formState === 'SUBMITTED_NO_AGENTS' && agentPolicies.length > 0 && packageInfo && savedPackagePolicy && /*#__PURE__*/_react.default.createElement(_components4.PostInstallAddAgentModal, {
    packageInfo: packageInfo,
    onConfirm: () => navigateAddAgent(savedPackagePolicy),
    onCancel: () => navigateAddAgentHelp(savedPackagePolicy)
  }), formState === 'SUBMITTED_AZURE_ARM_TEMPLATE' && agentPolicies.length > 0 && savedPackagePolicy && /*#__PURE__*/_react.default.createElement(_post_install_azure_arm_template_modal.PostInstallAzureArmTemplateModal, {
    agentPolicy: agentPolicies[0],
    packagePolicy: savedPackagePolicy,
    onConfirm: () => navigateAddAgent(savedPackagePolicy),
    onCancel: () => navigateAddAgentHelp(savedPackagePolicy)
  }), formState === 'SUBMITTED_CLOUD_FORMATION' && agentPolicies.length > 0 && savedPackagePolicy && /*#__PURE__*/_react.default.createElement(_post_install_cloud_formation_modal.PostInstallCloudFormationModal, {
    agentPolicy: agentPolicies[0],
    packagePolicy: savedPackagePolicy,
    onConfirm: () => navigateAddAgent(savedPackagePolicy),
    onCancel: () => navigateAddAgentHelp(savedPackagePolicy)
  }), formState === 'SUBMITTED_GOOGLE_CLOUD_SHELL' && agentPolicies.length > 0 && savedPackagePolicy && /*#__PURE__*/_react.default.createElement(_post_install_google_cloud_shell_modal.PostInstallGoogleCloudShellModal, {
    agentPolicy: agentPolicies[0],
    packagePolicy: savedPackagePolicy,
    onConfirm: () => navigateAddAgent(savedPackagePolicy),
    onCancel: () => navigateAddAgentHelp(savedPackagePolicy)
  }), packageInfo && /*#__PURE__*/_react.default.createElement(_components3.IntegrationBreadcrumb, {
    pkgTitle: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title) || packageInfo.title,
    pkgkey: (0, _services2.pkgKeyFromPackageInfo)(packageInfo),
    integration: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name
  }), packageInfo && (0, _services.isRootPrivilegesRequired)(packageInfo) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_root_callout.RootPrivilegesCallout, {
    dataStreams: rootPrivilegedDataStreams
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, numTransformAssets > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_transform_install_as_current_user_callout.TransformInstallWithCurrentUserPermissionCallout, {
    count: numTransformAssets
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })) : null, showSecretsDisabledCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    color: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.secretsDisabledCalloutTitle",
      defaultMessage: "Policy secrets are disabled"
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.secretsDisabledCalloutDescription",
    defaultMessage: "This integration contains {policySecretsLink}, but you have a Fleet Server running on a version earlier than {minimumSecretsVersion}. Please upgrade your Fleet Server to enable policy secrets for all integrations.",
    values: {
      policySecretsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.policySecrets,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.secretsDisabledCalloutDocsLink",
        defaultMessage: "policy secrets"
      })),
      minimumSecretsVersion: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _constants.SECRETS_MINIMUM_FLEET_SERVER_VERSION)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(StepsWithLessPadding, {
    steps: steps
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(CustomEuiBottomBar, {
    "data-test-subj": "integrationsBottomBar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, packageInfo && (formState === 'INVALID' || hasAgentPolicyError) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.errorOnSaveText",
    defaultMessage: "Your integration policy has errors. Please fix them before saving."
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    href: cancelUrl,
    onClick: cancelClickHandler,
    "data-test-subj": "createPackagePolicyCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.cancelButton",
    defaultMessage: "Cancel"
  }))), showDevtoolsRequest ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.DevtoolsRequestFlyoutButton, {
    request: devtoolRequest,
    description: devtoolRequestDescription,
    btnProps: {
      color: 'text'
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => onSubmit(),
    isLoading: formState === 'LOADING',
    disabled: formState !== 'VALID' || hasAgentPolicyError || !validationResults,
    iconType: "save",
    color: "primary",
    fill: true,
    "data-test-subj": "createPackagePolicySaveButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.saveButton",
    defaultMessage: "Save and continue"
  })))))))))));
};
exports.CreatePackagePolicySinglePage = CreatePackagePolicySinglePage;