"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UninstallTokenError = exports.PolicyNamespaceValidationError = exports.PackagePolicyValidationError = exports.OutputInvalidError = exports.MessageSigningError = exports.FleetError = exports.FleetActionsError = exports.FleetActionsClientError = exports.AgentRequestInvalidError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable max-classes-per-file */

class FleetError extends Error {
  constructor(message, meta) {
    super(message);
    (0, _defineProperty2.default)(this, "attributes", void 0);
    this.meta = meta;
    this.name = this.constructor.name; // for stack traces
  }
}
exports.FleetError = FleetError;
class PolicyNamespaceValidationError extends FleetError {}
exports.PolicyNamespaceValidationError = PolicyNamespaceValidationError;
class PackagePolicyValidationError extends FleetError {}
exports.PackagePolicyValidationError = PackagePolicyValidationError;
class MessageSigningError extends FleetError {}
exports.MessageSigningError = MessageSigningError;
class FleetActionsError extends FleetError {}
exports.FleetActionsError = FleetActionsError;
class FleetActionsClientError extends FleetError {}
exports.FleetActionsClientError = FleetActionsClientError;
class UninstallTokenError extends FleetError {}
exports.UninstallTokenError = UninstallTokenError;
class AgentRequestInvalidError extends FleetError {}
exports.AgentRequestInvalidError = AgentRequestInvalidError;
class OutputInvalidError extends FleetError {}
exports.OutputInvalidError = OutputInvalidError;