"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionXyPlugin = void 0;
exports.getTimeZone = getTimeZone;
var _moment = _interopRequireDefault(require("moment"));
var _common = require("@kbn/charts-plugin/common");
var _expression_functions = require("../common/expression_functions");
var _expression_renderers = require("./expression_renderers");
var _event_annotations_result = require("../common/expression_functions/event_annotations_result");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getTimeZone(uiSettings) {
  const configuredTimeZone = uiSettings.get('dateFormat:tz');
  if (configuredTimeZone === 'Browser') {
    return _moment.default.tz.guess();
  }
  return configuredTimeZone;
}
class ExpressionXyPlugin {
  setup(core, {
    expressions,
    charts: _charts
  }) {
    expressions.registerFunction(_expression_functions.yAxisConfigFunction);
    expressions.registerFunction(_expression_functions.dataDecorationConfigFunction);
    expressions.registerFunction(_expression_functions.referenceLineDecorationConfigFunction);
    expressions.registerFunction(_expression_functions.legendConfigFunction);
    expressions.registerFunction(_expression_functions.extendedDataLayerFunction);
    expressions.registerFunction(_expression_functions.axisExtentConfigFunction);
    expressions.registerFunction(_expression_functions.xAxisConfigFunction);
    expressions.registerFunction(_expression_functions.annotationLayerFunction);
    expressions.registerFunction(_expression_functions.extendedAnnotationLayerFunction);
    expressions.registerFunction(_event_annotations_result.eventAnnotationsResult);
    expressions.registerFunction(_expression_functions.referenceLineFunction);
    expressions.registerFunction(_expression_functions.referenceLineLayerFunction);
    expressions.registerFunction(_expression_functions.xyVisFunction);
    expressions.registerFunction(_expression_functions.layeredXyVisFunction);
    const getStartDeps = async () => {
      const [coreStart, deps] = await core.getStartServices();
      const {
        data,
        usageCollection,
        fieldFormats,
        eventAnnotation,
        charts: {
          activeCursor,
          theme,
          palettes
        }
      } = deps;
      const paletteService = await palettes.getPalettes();
      const {
        theme: kibanaTheme
      } = coreStart;
      const eventAnnotationService = await eventAnnotation.getService();
      const useLegacyTimeAxis = core.uiSettings.get(_common.LEGACY_TIME_AXIS);
      return {
        data,
        formatFactory: fieldFormats.deserialize,
        kibanaTheme,
        theme,
        usageCollection,
        activeCursor,
        paletteService,
        useLegacyTimeAxis,
        eventAnnotationService,
        timeZone: getTimeZone(core.uiSettings),
        timeFormat: core.uiSettings.get('dateFormat'),
        startServices: coreStart
      };
    };
    expressions.registerRenderer((0, _expression_renderers.getXyChartRenderer)({
      getStartDeps
    }));
  }
  start(_core) {}
  stop() {}
}
exports.ExpressionXyPlugin = ExpressionXyPlugin;