"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.imageRendererFactory = exports.getImageRenderer = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/presentation-util-plugin/common");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const strings = {
  getDisplayName: () => _i18n.i18n.translate('expressionImage.renderer.image.displayName', {
    defaultMessage: 'Image'
  }),
  getHelpDescription: () => _i18n.i18n.translate('expressionImage.renderer.image.helpDescription', {
    defaultMessage: 'Render an image'
  })
};
const getImageRenderer = core => () => ({
  name: 'image',
  displayName: strings.getDisplayName(),
  help: strings.getHelpDescription(),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    var _config$dataurl;
    const {
      elasticLogo
    } = await (0, _common.getElasticLogo)();
    const dataurl = (0, _common.isValidUrl)((_config$dataurl = config.dataurl) !== null && _config$dataurl !== void 0 ? _config$dataurl : '') ? config.dataurl : elasticLogo;
    const style = {
      height: '100%',
      backgroundImage: `url(${dataurl})`,
      backgroundRepeat: 'no-repeat',
      backgroundPosition: 'center center',
      backgroundSize: config.mode
    };
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundaryProvider, {
      analytics: undefined
    }, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, core, /*#__PURE__*/_react.default.createElement("div", {
      style: style
    })))), domNode, () => handlers.done());
  }
});
exports.getImageRenderer = getImageRenderer;
const imageRendererFactory = core => getImageRenderer(core);
exports.imageRendererFactory = imageRendererFactory;