"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ErrorComponent;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/presentation-util-plugin/public");
var _ = require(".");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const Error = (0, _public.withSuspense)(_.LazyErrorComponent);
function ErrorComponent({
  onLoaded,
  parentNode,
  error
}) {
  const getButtonSize = node => Math.min(node.clientHeight, node.clientWidth);
  const parentNodeDimensions = (0, _eui.useResizeObserver)(parentNode);
  const [buttonSize, setButtonSize] = (0, _react.useState)(getButtonSize(parentNode));
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const handlePopoverClick = () => setPopoverOpen(!isPopoverOpen);
  const closePopover = () => setPopoverOpen(false);
  const updateErrorView = (0, _react.useCallback)(() => {
    setButtonSize(getButtonSize(parentNode));
    onLoaded();
  }, [parentNode, onLoaded]);
  (0, _react.useEffect)(() => {
    updateErrorView();
  }, [parentNodeDimensions, updateErrorView]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasRenderError"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    closePopover: closePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      className: "canvasRenderError__icon",
      onClick: handlePopoverClick,
      style: {
        height: buttonSize,
        width: buttonSize
      },
      type: "warning"
    }),
    isOpen: isPopoverOpen
  }, /*#__PURE__*/_react.default.createElement(Error, {
    payload: {
      error
    },
    onClose: closePopover
  })));
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;