"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsKPIConfig = getAlertsKPIConfig;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAlertsKPIConfig({
  spaceId
}) {
  return {
    reportType: _constants.ReportTypes.KPI,
    defaultSeriesType: 'line',
    seriesTypes: [],
    xAxisColumn: {
      label: _i18n.i18n.translate('xpack.exploratoryView.alerts.alertStarted', {
        defaultMessage: 'Timestamp'
      }),
      dataType: 'date',
      operationType: 'date_histogram',
      isBucketed: true,
      scale: 'interval',
      sourceField: _constants.REPORT_METRIC_TIMESTAMP
    },
    yAxisColumns: [{
      sourceField: _constants.REPORT_METRIC_FIELD,
      operationType: 'count'
    }],
    hasOperationType: false,
    filterFields: ['kibana.alert.rule.name', 'kibana.alert.status'],
    breakdownFields: ['kibana.alert.rule.category', 'kibana.alert.status'],
    baseFilters: [],
    definitionFields: ['kibana.alert.rule.category'],
    metricOptions: [{
      label: 'Total alerts',
      field: _constants.RECORDS_FIELD,
      id: 'Alerts',
      columnType: 'unique_count',
      timestampField: 'kibana.alert.start'
    }, {
      label: 'Recovered alerts',
      field: _constants.RECORDS_FIELD,
      id: 'recovered_alerts',
      columnType: 'unique_count',
      timestampField: 'kibana.alert.end'
    }],
    labels: {
      ..._constants.FieldLabels
    },
    query: {
      language: 'kuery',
      query: `kibana.space_ids: "${spaceId}"`
    }
  };
}