"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlService = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EsqlService {
  constructor(options) {
    this.options = options;
  }
  async getIndexAliases(indices) {
    const result = {};
    const {
      client
    } = this.options;

    // Execute: GET /<index1,index2,...>/_alias

    const response = await client.indices.getAlias({
      index: indices
    });
    for (const [indexName, {
      aliases
    }] of Object.entries(response)) {
      const aliasNames = Object.keys(aliases !== null && aliases !== void 0 ? aliases : {});
      if (aliasNames.length > 0) {
        result[indexName] = aliasNames;
      }
    }
    return result;
  }
  async getJoinIndices() {
    const {
      client
    } = this.options;

    // Execute: GET /_all/_settings/index.mode,aliases?flat_settings=true

    const queryByIndexModeResponse = await client.indices.getSettings({
      name: 'index.mode',
      flat_settings: true
    });
    const indices = [];
    const indexNames = [];
    for (const [name, {
      settings
    }] of Object.entries(queryByIndexModeResponse)) {
      if (settings['index.mode'] === 'lookup') {
        indexNames.push(name);
        indices.push({
          name,
          mode: 'lookup',
          aliases: []
        });
      }
    }
    const aliases = await this.getIndexAliases(indexNames);
    for (const index of indices) {
      var _aliases$index$name;
      index.aliases = (_aliases$index$name = aliases[index.name]) !== null && _aliases$index$name !== void 0 ? _aliases$index$name : [];
    }
    const result = {
      indices
    };
    return result;
  }
}
exports.EsqlService = EsqlService;