"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValueControlForm = ValueControlForm;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _esqlValidationAutocomplete = require("@kbn/esql-validation-autocomplete");
var _esqlUtils = require("@kbn/esql-utils");
var _create_editor = require("../../../create_editor");
var _shared_form_components = require("./shared_form_components");
var _helpers = require("./helpers");
var _types = require("../types");
var _choose_column_popover = require("./choose_column_popover");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SUGGESTED_INTERVAL_VALUES = ['5 minutes', '1 hour', '1 day', '1 week', '1 month'];
function ValueControlForm({
  variableType,
  initialState,
  onCancelControl,
  queryString,
  esqlVariables,
  search,
  closeFlyout,
  onCreateControl,
  onEditControl
}) {
  var _initialState$control, _initialState$esqlQue, _initialState$title, _initialState$width, _initialState$grow;
  const valuesField = (0, _react.useMemo)(() => {
    if (variableType === _esqlValidationAutocomplete.ESQLVariableType.VALUES) {
      return (0, _esqlUtils.getValuesFromQueryField)(queryString);
    }
    return null;
  }, [variableType, queryString]);
  const suggestedVariableName = (0, _react.useMemo)(() => {
    const existingVariables = esqlVariables.filter(variable => variable.type === variableType);
    if (initialState) {
      return initialState.variableName;
    }
    if (valuesField && variableType === _esqlValidationAutocomplete.ESQLVariableType.VALUES) {
      // variables names can't have special characters, only underscore
      const fieldVariableName = valuesField.replace(/[^a-zA-Z0-9]/g, '_');
      return (0, _helpers.getRecurrentVariableName)(fieldVariableName, existingVariables.map(variable => variable.key));
    }
    if (variableType === _esqlValidationAutocomplete.ESQLVariableType.TIME_LITERAL) {
      return (0, _helpers.getRecurrentVariableName)('interval', existingVariables.map(variable => variable.key));
    }
    return (0, _helpers.getRecurrentVariableName)('variable', existingVariables.map(variable => variable.key));
  }, [esqlVariables, initialState, valuesField, variableType]);
  const [controlFlyoutType, setControlFlyoutType] = (0, _react.useState)((_initialState$control = initialState === null || initialState === void 0 ? void 0 : initialState.controlType) !== null && _initialState$control !== void 0 ? _initialState$control : variableType === _esqlValidationAutocomplete.ESQLVariableType.TIME_LITERAL ? _types.EsqlControlType.STATIC_VALUES : _types.EsqlControlType.VALUES_FROM_QUERY);
  const [availableValuesOptions, setAvailableValuesOptions] = (0, _react.useState)(variableType === _esqlValidationAutocomplete.ESQLVariableType.TIME_LITERAL ? SUGGESTED_INTERVAL_VALUES.map(option => {
    return {
      label: option,
      key: option,
      'data-test-subj': option
    };
  }) : []);
  const [selectedValues, setSelectedValues] = (0, _react.useState)(initialState ? initialState.availableOptions.map(option => {
    return {
      label: option,
      key: option,
      'data-test-subj': option
    };
  }) : []);
  const [valuesQuery, setValuesQuery] = (0, _react.useState)(variableType === _esqlValidationAutocomplete.ESQLVariableType.VALUES ? (_initialState$esqlQue = initialState === null || initialState === void 0 ? void 0 : initialState.esqlQuery) !== null && _initialState$esqlQue !== void 0 ? _initialState$esqlQue : '' : '');
  const [esqlQueryErrors, setEsqlQueryErrors] = (0, _react.useState)();
  const [formIsInvalid, setFormIsInvalid] = (0, _react.useState)(false);
  const [queryColumns, setQueryColumns] = (0, _react.useState)(valuesField ? [valuesField] : []);
  const [variableName, setVariableName] = (0, _react.useState)(suggestedVariableName);
  const [label, setLabel] = (0, _react.useState)((_initialState$title = initialState === null || initialState === void 0 ? void 0 : initialState.title) !== null && _initialState$title !== void 0 ? _initialState$title : '');
  const [minimumWidth, setMinimumWidth] = (0, _react.useState)((_initialState$width = initialState === null || initialState === void 0 ? void 0 : initialState.width) !== null && _initialState$width !== void 0 ? _initialState$width : 'medium');
  const [grow, setGrow] = (0, _react.useState)((_initialState$grow = initialState === null || initialState === void 0 ? void 0 : initialState.grow) !== null && _initialState$grow !== void 0 ? _initialState$grow : false);
  const isControlInEditMode = (0, _react.useMemo)(() => !!initialState, [initialState]);
  const areValuesValid = (0, _react.useMemo)(() => {
    return variableType === _esqlValidationAutocomplete.ESQLVariableType.TIME_LITERAL ? (0, _helpers.areValuesIntervalsValid)(selectedValues.map(option => option.label)) : true;
  }, [variableType, selectedValues]);
  (0, _react.useEffect)(() => {
    const variableExists = esqlVariables.some(variable => variable.key === variableName.replace('?', '')) && !isControlInEditMode;
    setFormIsInvalid(!variableName || variableExists || !areValuesValid || !selectedValues.length);
  }, [areValuesValid, esqlVariables, isControlInEditMode, selectedValues.length, valuesQuery, variableName]);
  const onValuesChange = (0, _react.useCallback)(selectedOptions => {
    setSelectedValues(selectedOptions);
  }, []);
  const onFlyoutTypeChange = (0, _react.useCallback)(type => {
    setControlFlyoutType(type);
    if (type !== controlFlyoutType && variableType === _esqlValidationAutocomplete.ESQLVariableType.TIME_LITERAL) {
      setSelectedValues([]);
    }
  }, [controlFlyoutType, variableType]);
  const onCreateOption = (0, _react.useCallback)((searchValue, flattenedOptions = []) => {
    if (!searchValue) {
      return;
    }
    const normalizedSearchValue = searchValue.trim().toLowerCase();
    const newOption = {
      'data-test-subj': searchValue,
      label: searchValue,
      key: searchValue
    };
    if (flattenedOptions.findIndex(option => option.label.trim().toLowerCase() === normalizedSearchValue) === -1) {
      setAvailableValuesOptions([...availableValuesOptions, newOption]);
    }
    setSelectedValues(prevSelected => [...prevSelected, newOption]);
  }, [availableValuesOptions]);
  const onVariableNameChange = (0, _react.useCallback)(e => {
    const text = (0, _helpers.validateVariableName)(String(e.target.value));
    setVariableName(text);
  }, []);
  const onLabelChange = (0, _react.useCallback)(e => {
    setLabel(e.target.value);
  }, []);
  const onMinimumSizeChange = (0, _react.useCallback)(optionId => {
    if (optionId) {
      setMinimumWidth(optionId);
    }
  }, []);
  const onGrowChange = (0, _react.useCallback)(e => {
    setGrow(e.target.checked);
  }, []);
  const onValuesQuerySubmit = (0, _react.useCallback)(async query => {
    try {
      (0, _esqlUtils.getESQLResults)({
        esqlQuery: query,
        search,
        signal: undefined,
        filter: undefined,
        dropNullColumns: true
      }).then(results => {
        const columns = results.response.columns.map(col => col.name);
        setQueryColumns(columns);
        if (columns.length === 1) {
          const valuesArray = results.response.values.map(value => value[0]);
          const options = valuesArray.filter(v => v).map(option => {
            return {
              label: String(option),
              key: String(option),
              'data-test-subj': String(option)
            };
          });
          setSelectedValues(options);
          setAvailableValuesOptions(options);
          setEsqlQueryErrors([]);
        }
      });
      setValuesQuery(query);
    } catch (e) {
      setEsqlQueryErrors([e]);
    }
  }, [search]);
  (0, _react.useEffect)(() => {
    if (!(selectedValues !== null && selectedValues !== void 0 && selectedValues.length) && controlFlyoutType === _types.EsqlControlType.VALUES_FROM_QUERY && valuesField) {
      const queryForValues = suggestedVariableName !== '' ? `FROM ${(0, _esqlUtils.getIndexPatternFromESQLQuery)(queryString)} | STATS BY ${valuesField}` : '';
      onValuesQuerySubmit(queryForValues);
    }
  }, [controlFlyoutType, onValuesQuerySubmit, queryString, selectedValues === null || selectedValues === void 0 ? void 0 : selectedValues.length, suggestedVariableName, valuesField, variableName]);
  const onCreateValueControl = (0, _react.useCallback)(async () => {
    const availableOptions = selectedValues.map(value => value.label);
    const state = {
      availableOptions,
      selectedOptions: [availableOptions[0]],
      width: minimumWidth,
      title: label || variableName,
      variableName,
      variableType,
      esqlQuery: valuesQuery || queryString,
      controlType: controlFlyoutType,
      grow
    };
    if (availableOptions.length) {
      if (!isControlInEditMode) {
        await onCreateControl(state, variableName);
      } else {
        onEditControl(state);
      }
    }
    closeFlyout();
  }, [selectedValues, controlFlyoutType, minimumWidth, label, variableName, variableType, valuesQuery, queryString, grow, closeFlyout, isControlInEditMode, onCreateControl, onEditControl]);
  const updateQuery = (0, _react.useCallback)(column => {
    const updatedQuery = (0, _esqlUtils.appendStatsByToQuery)(valuesQuery, column);
    onValuesQuerySubmit(updatedQuery);
  }, [onValuesQuerySubmit, valuesQuery]);
  const styling = (0, _react.useMemo)(() => (0, _helpers.getFlyoutStyling)(), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_form_components.Header, {
    isInEditMode: isControlInEditMode
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: (0, _react2.css)`
          ${styling}
        `
  }, /*#__PURE__*/_react.default.createElement(_shared_form_components.ControlType, {
    isDisabled: false,
    initialControlFlyoutType: controlFlyoutType,
    onFlyoutTypeChange: onFlyoutTypeChange
  }), /*#__PURE__*/_react.default.createElement(_shared_form_components.VariableName, {
    variableName: variableName,
    isControlInEditMode: isControlInEditMode,
    onVariableNameChange: onVariableNameChange,
    esqlVariables: esqlVariables
  }), controlFlyoutType === _types.EsqlControlType.VALUES_FROM_QUERY && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.valuesQueryEditor.label', {
      defaultMessage: 'Values query'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_create_editor.ESQLLangEditor, {
    query: {
      esql: valuesQuery
    },
    onTextLangQueryChange: q => {
      setValuesQuery(q.esql);
    },
    hideTimeFilterInfo: true,
    disableAutoFocus: true,
    errors: esqlQueryErrors,
    editorIsInline: true,
    hideRunQueryText: true,
    onTextLangQuerySubmit: async (q, a) => {
      if (q) {
        await onValuesQuerySubmit(q.esql);
      }
    },
    isDisabled: false,
    isLoading: false
  })), queryColumns.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.previewValues.placeholder', {
      defaultMessage: 'Values preview'
    }),
    fullWidth: true
  }, queryColumns.length === 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    color: "primary",
    css: (0, _react2.css)`
                      white-space: wrap;
                      overflow-y: auto;
                      max-height: 200px;
                    `,
    "data-test-subj": "esqlValuesPreview"
  }, selectedValues.map(value => value.label).join(', ')) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('esql.flyout.displayMultipleColsCallout.title', {
      defaultMessage: 'Your query must return a single column'
    }),
    color: "warning",
    iconType: "warning",
    size: "s",
    "data-test-subj": "esqlMoreThanOneColumnCallout"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "esql.flyout.displayMultipleColsCallout.description",
    defaultMessage: "Your query is currently returning {totalColumns} columns. Choose column {chooseColumnPopover} or use {boldText}.",
    values: {
      totalColumns: queryColumns.length,
      boldText: /*#__PURE__*/_react.default.createElement("strong", null, "STATS BY"),
      chooseColumnPopover: /*#__PURE__*/_react.default.createElement(_choose_column_popover.ChooseColumnPopover, {
        columns: queryColumns,
        updateQuery: updateQuery
      })
    }
  }))))), controlFlyoutType === _types.EsqlControlType.STATIC_VALUES && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.values.label', {
      defaultMessage: 'Values'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('esql.flyout.values.placeholder', {
      defaultMessage: 'Select or add values'
    }),
    placeholder: _i18n.i18n.translate('esql.flyout.values.placeholder', {
      defaultMessage: 'Select or add values'
    }),
    "data-test-subj": "esqlValuesOptions",
    options: availableValuesOptions,
    selectedOptions: selectedValues,
    onChange: onValuesChange,
    onCreateOption: onCreateOption,
    fullWidth: true,
    compressed: true,
    css: (0, _react2.css)`
                max-height: 200px;
                overflow-y: auto;
              `
  })), /*#__PURE__*/_react.default.createElement(_shared_form_components.ControlLabel, {
    label: label,
    onLabelChange: onLabelChange
  }), /*#__PURE__*/_react.default.createElement(_shared_form_components.ControlWidth, {
    minimumWidth: minimumWidth,
    grow: grow,
    onMinimumSizeChange: onMinimumSizeChange,
    onGrowChange: onGrowChange
  })), /*#__PURE__*/_react.default.createElement(_shared_form_components.Footer, {
    isControlInEditMode: isControlInEditMode,
    variableName: variableName,
    onCancelControl: onCancelControl,
    isSaveDisabled: formIsInvalid,
    closeFlyout: closeFlyout,
    onCreateControl: onCreateValueControl
  }));
}