"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateVariableName = exports.updateQueryStringWithVariable = exports.getRecurrentVariableName = exports.getQueryForFields = exports.getFlyoutStyling = exports.areValuesIntervalsValid = void 0;
var _esqlValidationAutocomplete = require("@kbn/esql-validation-autocomplete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function inKnownTimeInterval(timeIntervalUnit) {
  return _esqlValidationAutocomplete.timeUnits.some(unit => unit === timeIntervalUnit.toLowerCase());
}
const updateQueryStringWithVariable = (queryString, variable, cursorPosition) => {
  var _cursorPosition$colum, _cursorPosition$lineN;
  const variableName = `?${variable}`;
  const cursorColumn = (_cursorPosition$colum = cursorPosition === null || cursorPosition === void 0 ? void 0 : cursorPosition.column) !== null && _cursorPosition$colum !== void 0 ? _cursorPosition$colum : 0;
  const cursorLine = (_cursorPosition$lineN = cursorPosition === null || cursorPosition === void 0 ? void 0 : cursorPosition.lineNumber) !== null && _cursorPosition$lineN !== void 0 ? _cursorPosition$lineN : 0;
  const lines = queryString.split('\n');
  if (lines.length > 1) {
    const queryArray = queryString.split('\n');
    const queryPartToBeUpdated = queryArray[cursorLine - 1];
    const queryWithVariable = [queryPartToBeUpdated.slice(0, cursorColumn - 1), variableName, queryPartToBeUpdated.slice(cursorColumn - 1)].join('');
    queryArray[cursorLine - 1] = queryWithVariable;
    return queryArray.join('\n');
  }
  return [queryString.slice(0, cursorColumn - 1), variableName, queryString.slice(cursorColumn - 1)].join('');
};
exports.updateQueryStringWithVariable = updateQueryStringWithVariable;
const getQueryForFields = (queryString, cursorPosition) => {
  var _cursorPosition$colum2, _cursorPosition$lineN2;
  const cursorColumn = (_cursorPosition$colum2 = cursorPosition === null || cursorPosition === void 0 ? void 0 : cursorPosition.column) !== null && _cursorPosition$colum2 !== void 0 ? _cursorPosition$colum2 : 0;
  const cursorLine = (_cursorPosition$lineN2 = cursorPosition === null || cursorPosition === void 0 ? void 0 : cursorPosition.lineNumber) !== null && _cursorPosition$lineN2 !== void 0 ? _cursorPosition$lineN2 : 0;
  const lines = queryString.split('\n');
  if (lines.length > 1) {
    const queryArray = queryString.split('\n');
    const lineToBeUpdated = cursorLine - 1;
    return queryArray.slice(0, lineToBeUpdated).join('\n');
  }
  const queryBefore = queryString.slice(0, cursorColumn - 1);
  const pipes = queryBefore.split('|');
  return pipes.slice(0, pipes.length - 1).join('|');
};
exports.getQueryForFields = getQueryForFields;
const areValuesIntervalsValid = values => {
  return values.every(value => {
    // remove digits and empty spaces from the string to get the unit
    const unit = value.replace(/[0-9]/g, '').replace(/\s/g, '');
    return inKnownTimeInterval(unit);
  });
};
exports.areValuesIntervalsValid = areValuesIntervalsValid;
const getRecurrentVariableName = (name, existingNames) => {
  let newName = name;
  let i = 1;
  while (existingNames.includes(newName)) {
    newName = `${name}${i}`;
    i++;
  }
  return newName;
};
exports.getRecurrentVariableName = getRecurrentVariableName;
const getFlyoutStyling = () => {
  return `
          .euiFlyoutBody__overflow {
            -webkit-mask-image: none;
            padding-left: inherit;
            margin-left: inherit;
            transform: initial;
          }
          .euiFlyoutBody__overflowContent {
            block-size: 100%;
          }
  `;
};
exports.getFlyoutStyling = getFlyoutStyling;
const validateVariableName = variableName => {
  let text = variableName
  // variable name can only contain letters, numbers and underscores
  .replace(/[^a-zA-Z0-9_]/g, '');
  if (text.charAt(0) === '_') {
    text = text.substring(1);
  }
  return text;
};
exports.validateVariableName = validateVariableName;