"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _triggers = require("./triggers");
var _kibana_services = require("./kibana_services");
var _cache = require("./util/cache");
var _variables_service = require("./variables_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EsqlPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "indexManagement", void 0);
  }
  setup(_, {
    indexManagement,
    uiActions
  }) {
    this.indexManagement = indexManagement;
    uiActions.registerTrigger(_triggers.updateESQLQueryTrigger);
    uiActions.registerTrigger(_triggers.esqlControlTrigger);
    return {};
  }
  start(core, {
    dataViews,
    expressions,
    data,
    uiActions,
    fieldsMetadata,
    usageCollection
  }) {
    const storage = new _public.Storage(localStorage);

    // Register triggers
    const appendESQLAction = new _triggers.UpdateESQLQueryAction(data);
    uiActions.addTriggerAction(_triggers.UPDATE_ESQL_QUERY_TRIGGER, appendESQLAction);
    const createESQLControlAction = new _triggers.CreateESQLControlAction(core, data.search.search);
    uiActions.addTriggerAction(_triggers.ESQL_CONTROL_TRIGGER, createESQLControlAction);
    const variablesService = new _variables_service.EsqlVariablesService();
    const getJoinIndicesAutocomplete = (0, _cache.cacheNonParametrizedAsyncFunction)(async () => {
      const result = await core.http.get('/internal/esql/autocomplete/join/indices');
      return result;
    }, 1000 * 60 * 5,
    // Keep the value in cache for 5 minutes
    1000 * 15 // Refresh the cache in the background only if 15 seconds passed since the last call
    );
    const start = {
      getJoinIndicesAutocomplete,
      variablesService
    };
    (0, _kibana_services.setKibanaServices)(start, core, dataViews, data, expressions, storage, uiActions, this.indexManagement, fieldsMetadata, usageCollection);
    return start;
  }
  stop() {}
}
exports.EsqlPlugin = EsqlPlugin;