"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compareTypesWithLiterals = exports.ESQL_STRING_TYPES = exports.ESQL_NUMERIC_DECIMAL_TYPES = exports.ESQL_NUMBER_TYPES = exports.ESQL_DATE_TYPES = exports.ESQL_COMMON_NUMERIC_TYPES = void 0;
exports.isNumericType = isNumericType;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ESQL_COMMON_NUMERIC_TYPES = exports.ESQL_COMMON_NUMERIC_TYPES = ['double', 'long', 'integer'];
const ESQL_NUMERIC_DECIMAL_TYPES = exports.ESQL_NUMERIC_DECIMAL_TYPES = ['double', 'unsigned_long', 'long', 'counter_long', 'counter_double'];
const ESQL_NUMBER_TYPES = exports.ESQL_NUMBER_TYPES = ['integer', 'counter_integer', ...ESQL_NUMERIC_DECIMAL_TYPES];
const ESQL_STRING_TYPES = exports.ESQL_STRING_TYPES = ['keyword', 'text'];
const ESQL_DATE_TYPES = exports.ESQL_DATE_TYPES = ['datetime', 'date_period'];
function isNumericType(type) {
  return typeof type === 'string' && [...ESQL_NUMBER_TYPES, 'decimal'].includes(type);
}

/**
 * Compares two types, taking into account literal types
 * @TODO strengthen typing here (remove `string`)
 * @TODO — clean up time duration and date period
 */
const compareTypesWithLiterals = (a, b) => {
  if (a === b) {
    return true;
  }
  // In Elasticsearch function definitions, time_literal and time_duration are used
  // time_duration is seconds/min/hour interval
  // date_period is day/week/month/year interval
  // time_literal includes time_duration and date_period
  // So they are equivalent AST's 'timeInterval' (a date unit constant: e.g. 1 year, 15 month)
  if (a === 'time_literal' || a === 'time_duration' || a === 'date_period') return b === 'timeInterval';
  if (b === 'time_literal' || b === 'time_duration' || b === 'date_period') return a === 'timeInterval';
  return false;
};
exports.compareTypesWithLiterals = compareTypesWithLiterals;