"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = void 0;
var _i18n = require("@kbn/i18n");
var _esqlAst = require("@kbn/esql-ast");
var _util = require("./util");
var _factories = require("../../factories");
var _complete_items = require("../../complete_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getFullCommandMnemonics = definition => {
  var _definition$types;
  const types = (_definition$types = definition.types) !== null && _definition$types !== void 0 ? _definition$types : [];
  if (!types.length) {
    return [[definition.name, definition.description]];
  }
  return types.map(type => {
    var _type$description;
    return [`${type.name.toUpperCase()} ${definition.name.toUpperCase()}`, (_type$description = type.description) !== null && _type$description !== void 0 ? _type$description : definition.description];
  });
};
const suggestFields = async (command, getColumnsByType, callbacks) => {
  var _callbacks$getColumns, _callbacks$canSuggest, _callbacks$canSuggest2;
  const summary = _esqlAst.mutate.commands.join.summarizeCommand(command);
  const joinIndexPattern = _esqlAst.LeafPrinter.print(summary.target.index);
  const [lookupIndexFields, sourceFields] = await Promise.all([callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getColumns = callbacks.getColumnsFor) === null || _callbacks$getColumns === void 0 ? void 0 : _callbacks$getColumns.call(callbacks, {
    query: `FROM ${joinIndexPattern}`
  }), getColumnsByType(['any'], [], {
    advanceCursor: true,
    openSuggestions: true
  })]);
  const supportsControls = (_callbacks$canSuggest = callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$canSuggest2 = callbacks.canSuggestVariables) === null || _callbacks$canSuggest2 === void 0 ? void 0 : _callbacks$canSuggest2.call(callbacks)) !== null && _callbacks$canSuggest !== void 0 ? _callbacks$canSuggest : false;
  const getVariablesByType = callbacks === null || callbacks === void 0 ? void 0 : callbacks.getVariablesByType;
  const joinFields = (0, _factories.buildFieldsDefinitionsWithMetadata)(lookupIndexFields, {
    supportsControls
  }, getVariablesByType);
  const intersection = (0, _util.suggestionIntersection)(joinFields, sourceFields);
  const union = (0, _util.suggestionUnion)(sourceFields, joinFields);
  for (const commonField of intersection) {
    commonField.sortText = '1';
    commonField.documentation = {
      value: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.join.sharedField', {
        defaultMessage: 'Field shared between the source and the lookup index'
      })
    };
    let detail = commonField.detail || '';
    if (detail) {
      detail += ' ';
    }
    detail += _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.join.commonFieldNote', {
      defaultMessage: '(common field)'
    });
    commonField.detail = detail;
  }
  return [...intersection, ...union];
};
const suggest = async (innerText, command, getColumnsByType, columnExists, getSuggestedVariableName, getExpressionType, getPreferences, previousCommands, definition, callbacks) => {
  let commandText = innerText;
  if (command.location) {
    commandText = innerText.slice(command.location.min);
  }
  const position = (0, _util.getPosition)(commandText, command);
  switch (position.pos) {
    case 'type':
    case 'after_type':
    case 'mnemonic':
      {
        const allMnemonics = getFullCommandMnemonics(definition);
        const filteredMnemonics = allMnemonics.filter(([mnemonic]) => mnemonic.startsWith(commandText.toUpperCase()));
        if (!filteredMnemonics.length) {
          return [];
        }
        return filteredMnemonics.map(([mnemonic, description], i) => ({
          label: mnemonic,
          text: mnemonic + ' $0',
          detail: description,
          kind: 'Keyword',
          sortText: `${i}-MNEMONIC`,
          command: _factories.TRIGGER_SUGGESTION_COMMAND
        }));
      }
    case 'after_mnemonic':
    case 'index':
      {
        var _callbacks$getJoinInd;
        const joinIndices = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getJoinInd = callbacks.getJoinIndices) === null || _callbacks$getJoinInd === void 0 ? void 0 : _callbacks$getJoinInd.call(callbacks));
        if (!joinIndices) {
          return [];
        }
        return (0, _util.joinIndicesToSuggestions)(joinIndices.indices);
      }
    case 'after_index':
      {
        const suggestion = {
          label: 'ON',
          text: 'ON ',
          detail: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.join.onKeyword', {
            defaultMessage: 'Specify JOIN field conditions'
          }),
          kind: 'Keyword',
          sortText: '0-ON',
          command: _factories.TRIGGER_SUGGESTION_COMMAND
        };
        return [suggestion];
      }
    case 'after_on':
      {
        const fields = await suggestFields(command, getColumnsByType, callbacks);
        return fields;
      }
    case 'condition':
      {
        var _match$groups;
        const endingWhitespaceRegex = /(?<comma>,)?(?<whitespace>\s{0,99})$/;
        const match = commandText.match(endingWhitespaceRegex);
        const commaIsLastToken = !!(match !== null && match !== void 0 && (_match$groups = match.groups) !== null && _match$groups !== void 0 && _match$groups.comma);
        if (commaIsLastToken) {
          const fields = await suggestFields(command, getColumnsByType, callbacks);
          return fields;
        }
        return [_complete_items.pipeCompleteItem, _complete_items.commaCompleteItem];
      }
  }
  const suggestions = [];
  return suggestions;
};
exports.suggest = suggest;