"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStatsCommand = void 0;
var _builder = require("../../builder");
var _utils = require("../../visitor/utils");
var _factories = require("../factories");
var _walkers = require("../walkers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createField = ctx => (0, _walkers.visitField)(ctx)[0];
const createAggField = ctx => {
  var _firstItem$location$m, _firstItem, _firstItem$location, _firstItem$location$m2, _firstItem2, _firstItem2$location;
  const fieldCtx = ctx.field();
  const field = createField(fieldCtx);
  const booleanExpression = ctx.booleanExpression();
  if (!booleanExpression) {
    return field;
  }
  const condition = (0, _walkers.collectBooleanExpression)(booleanExpression)[0];
  const aggField = _builder.Builder.expression.where([field, condition], {}, {
    location: {
      min: (_firstItem$location$m = (_firstItem = (0, _utils.firstItem)([(0, _utils.resolveItem)(field)])) === null || _firstItem === void 0 ? void 0 : (_firstItem$location = _firstItem.location) === null || _firstItem$location === void 0 ? void 0 : _firstItem$location.min) !== null && _firstItem$location$m !== void 0 ? _firstItem$location$m : 0,
      max: (_firstItem$location$m2 = (_firstItem2 = (0, _utils.firstItem)([(0, _utils.resolveItem)(condition)])) === null || _firstItem2 === void 0 ? void 0 : (_firstItem2$location = _firstItem2.location) === null || _firstItem2$location === void 0 ? void 0 : _firstItem2$location.max) !== null && _firstItem$location$m2 !== void 0 ? _firstItem$location$m2 : 0
    }
  });
  return aggField;
};
const createStatsCommand = (ctx, src) => {
  const command = (0, _factories.createCommand)('stats', ctx);
  if (ctx._stats) {
    const fields = ctx.aggFields();
    for (const fieldCtx of fields.aggField_list()) {
      const node = createAggField(fieldCtx);
      command.args.push(node);
    }
  }
  if (ctx._grouping) {
    const options = (0, _walkers.visitByOption)(ctx, ctx.fields());
    command.args.push(...options);
  }
  return command;
};
exports.createStatsCommand = createStatsCommand;