// Generated by Peggy 1.2.0.
//
// https://peggyjs.org/

"use strict";

function peg$subclass(child, parent) {
  function C() { this.constructor = child; }
  C.prototype = parent.prototype;
  child.prototype = new C();
}

function peg$SyntaxError(message, expected, found, location) {
  var self = Error.call(this, message);
  if (Object.setPrototypeOf) {
    Object.setPrototypeOf(self, peg$SyntaxError.prototype);
  }
  self.expected = expected;
  self.found = found;
  self.location = location;
  self.name = "SyntaxError";
  return self;
}

peg$subclass(peg$SyntaxError, Error);

function peg$padEnd(str, targetLength, padString) {
  padString = padString || " ";
  if (str.length > targetLength) { return str; }
  targetLength -= str.length;
  padString += padString.repeat(targetLength);
  return str + padString.slice(0, targetLength);
}

peg$SyntaxError.prototype.format = function(sources) {
  var str = "Error: " + this.message;
  if (this.location) {
    var src = null;
    var k;
    for (k = 0; k < sources.length; k++) {
      if (sources[k].source === this.location.source) {
        src = sources[k].text.split(/\r\n|\n|\r/g);
        break;
      }
    }
    var s = this.location.start;
    var loc = this.location.source + ":" + s.line + ":" + s.column;
    if (src) {
      var e = this.location.end;
      var filler = peg$padEnd("", s.line.toString().length);
      var line = src[s.line - 1];
      var last = s.line === e.line ? e.column : line.length + 1;
      str += "\n --> " + loc + "\n"
          + filler + " |\n"
          + s.line + " | " + line + "\n"
          + filler + " | " + peg$padEnd("", s.column - 1)
          + peg$padEnd("", last - s.column, "^");
    } else {
      str += "\n at " + loc;
    }
  }
  return str;
};

peg$SyntaxError.buildMessage = function(expected, found) {
  var DESCRIBE_EXPECTATION_FNS = {
    literal: function(expectation) {
      return "\"" + literalEscape(expectation.text) + "\"";
    },

    class: function(expectation) {
      var escapedParts = expectation.parts.map(function(part) {
        return Array.isArray(part)
          ? classEscape(part[0]) + "-" + classEscape(part[1])
          : classEscape(part);
      });

      return "[" + (expectation.inverted ? "^" : "") + escapedParts + "]";
    },

    any: function() {
      return "any character";
    },

    end: function() {
      return "end of input";
    },

    other: function(expectation) {
      return expectation.description;
    }
  };

  function hex(ch) {
    return ch.charCodeAt(0).toString(16).toUpperCase();
  }

  function literalEscape(s) {
    return s
      .replace(/\\/g, "\\\\")
      .replace(/"/g,  "\\\"")
      .replace(/\0/g, "\\0")
      .replace(/\t/g, "\\t")
      .replace(/\n/g, "\\n")
      .replace(/\r/g, "\\r")
      .replace(/[\x00-\x0F]/g,          function(ch) { return "\\x0" + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return "\\x"  + hex(ch); });
  }

  function classEscape(s) {
    return s
      .replace(/\\/g, "\\\\")
      .replace(/\]/g, "\\]")
      .replace(/\^/g, "\\^")
      .replace(/-/g,  "\\-")
      .replace(/\0/g, "\\0")
      .replace(/\t/g, "\\t")
      .replace(/\n/g, "\\n")
      .replace(/\r/g, "\\r")
      .replace(/[\x00-\x0F]/g,          function(ch) { return "\\x0" + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return "\\x"  + hex(ch); });
  }

  function describeExpectation(expectation) {
    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
  }

  function describeExpected(expected) {
    var descriptions = expected.map(describeExpectation);
    var i, j;

    descriptions.sort();

    if (descriptions.length > 0) {
      for (i = 1, j = 1; i < descriptions.length; i++) {
        if (descriptions[i - 1] !== descriptions[i]) {
          descriptions[j] = descriptions[i];
          j++;
        }
      }
      descriptions.length = j;
    }

    switch (descriptions.length) {
      case 1:
        return descriptions[0];

      case 2:
        return descriptions[0] + " or " + descriptions[1];

      default:
        return descriptions.slice(0, -1).join(", ")
          + ", or "
          + descriptions[descriptions.length - 1];
    }
  }

  function describeFound(found) {
    return found ? "\"" + literalEscape(found) + "\"" : "end of input";
  }

  return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
};

function peg$parse(input, options) {
  options = options !== undefined ? options : {};

  var peg$FAILED = {};
  var peg$source = options.grammarSource;

  var peg$startRuleFunctions = { start: peg$parsestart, Literal: peg$parseLiteral };
  var peg$startRuleFunction = peg$parsestart;

  var peg$c0 = "(";
  var peg$c1 = ")";
  var peg$c2 = ":";
  var peg$c3 = "{";
  var peg$c4 = "}";
  var peg$c5 = "or";
  var peg$c6 = "and";
  var peg$c7 = "not";
  var peg$c8 = "\"";
  var peg$c9 = "\\";
  var peg$c10 = "*";
  var peg$c11 = "\\t";
  var peg$c12 = "\\r";
  var peg$c13 = "\\n";
  var peg$c14 = "u";
  var peg$c15 = "<=";
  var peg$c16 = ">=";
  var peg$c17 = "<";
  var peg$c18 = ">";
  var peg$c19 = "@kuery-cursor@";

  var peg$r0 = /^[\\"]/;
  var peg$r1 = /^[^"]/;
  var peg$r2 = /^[\\():<>"*{}]/;
  var peg$r3 = /^[0-9a-f]/i;
  var peg$r4 = /^[ \t\r\n\xA0]/;

  var peg$e0 = peg$literalExpectation("(", false);
  var peg$e1 = peg$literalExpectation(")", false);
  var peg$e2 = peg$literalExpectation(":", false);
  var peg$e3 = peg$literalExpectation("{", false);
  var peg$e4 = peg$literalExpectation("}", false);
  var peg$e5 = peg$otherExpectation("fieldName");
  var peg$e6 = peg$otherExpectation("value");
  var peg$e7 = peg$otherExpectation("OR");
  var peg$e8 = peg$literalExpectation("or", true);
  var peg$e9 = peg$otherExpectation("AND");
  var peg$e10 = peg$literalExpectation("and", true);
  var peg$e11 = peg$otherExpectation("NOT");
  var peg$e12 = peg$literalExpectation("not", true);
  var peg$e13 = peg$otherExpectation("literal");
  var peg$e14 = peg$literalExpectation("\"", false);
  var peg$e15 = peg$literalExpectation("\\", false);
  var peg$e16 = peg$classExpectation(["\\", "\""], false, false);
  var peg$e17 = peg$classExpectation(["\""], true, false);
  var peg$e18 = peg$anyExpectation();
  var peg$e19 = peg$literalExpectation("*", false);
  var peg$e20 = peg$literalExpectation("\\t", false);
  var peg$e21 = peg$literalExpectation("\\r", false);
  var peg$e22 = peg$literalExpectation("\\n", false);
  var peg$e23 = peg$classExpectation(["\\", "(", ")", ":", "<", ">", "\"", "*", "{", "}"], false, false);
  var peg$e24 = peg$literalExpectation("u", false);
  var peg$e25 = peg$classExpectation([["0", "9"], ["a", "f"]], false, true);
  var peg$e26 = peg$literalExpectation("<=", false);
  var peg$e27 = peg$literalExpectation(">=", false);
  var peg$e28 = peg$literalExpectation("<", false);
  var peg$e29 = peg$literalExpectation(">", false);
  var peg$e30 = peg$otherExpectation("whitespace");
  var peg$e31 = peg$classExpectation([" ", "\t", "\r", "\n", "\xA0"], false, false);
  var peg$e32 = peg$literalExpectation("@kuery-cursor@", false);

  var peg$f0 = function(query, trailing) {
      if (trailing.type === 'cursor') {
        return {
          ...trailing,
          suggestionTypes: ['conjunction']
        };
      }
      if (query !== null) return query;
      return nodeTypes.function.buildNode('is', '*', '*');
    };
  var peg$f1 = function(head, query) { return query; };
  var peg$f2 = function(head, tail) {
      const nodes = [head, ...tail];
      const cursor = parseCursor && nodes.find(node => node.type === 'cursor');
      if (cursor) return cursor;
      return buildFunctionNode('or', nodes);
    };
  var peg$f3 = function(head, tail) {
      const nodes = [head, ...tail];
      const cursor = parseCursor && nodes.find(node => node.type === 'cursor');
      if (cursor) return cursor;
      return buildFunctionNode('and', nodes);
    };
  var peg$f4 = function(query) {
      if (query.type === 'cursor') return query;
      return buildFunctionNode('not', [query]);
    };
  var peg$f5 = function(query, trailing) {
      if (trailing.type === 'cursor') {
        return {
          ...trailing,
          suggestionTypes: ['conjunction']
        };
      }
      return query;
    };
  var peg$f6 = function(field, query, trailing) {
        if (query.type === 'cursor') {
          return {
            ...query,
            nestedPath: query.nestedPath ? `${field.value}.${query.nestedPath}` : field.value,
          }
        };

        if (trailing.type === 'cursor') {
          return {
            ...trailing,
            suggestionTypes: ['conjunction']
          };
        }
        return buildFunctionNode('nested', [field, query]);
      };
  var peg$f7 = function(field, operator, value) {
      if (value.type === 'cursor') {
        return {
          ...value,
          suggestionTypes: ['conjunction']
        };
      }
      return buildFunctionNode('range', [field, operator, value]);
    };
  var peg$f8 = function(field, partial) {
      if (partial.type === 'cursor') {
        return {
          ...partial,
          fieldName: field.value,
          suggestionTypes: ['value', 'conjunction']
        };
      }
      return partial(field);
    };
  var peg$f9 = function(partial) {
      if (partial.type === 'cursor') {
        const fieldName = `${partial.prefix}${partial.suffix}`.trim();
        return {
          ...partial,
          fieldName,
          suggestionTypes: ['field', 'operator', 'conjunction']
        };
      }
      const field = buildLiteralNode(null);
      return partial(field);
    };
  var peg$f10 = function(partial, trailing) {
      if (trailing.type === 'cursor') {
        return {
          ...trailing,
          suggestionTypes: ['conjunction']
        };
      }
      return partial;
    };
  var peg$f11 = function(head, partial) { return partial; };
  var peg$f12 = function(head, tail) {
      const nodes = [head, ...tail];
      const cursor = parseCursor && nodes.find(node => node.type === 'cursor');
      if (cursor) {
        return {
          ...cursor,
          suggestionTypes: ['value']
        };
      }
      return (field) => buildFunctionNode('or', nodes.map(partial => partial(field)));
    };
  var peg$f13 = function(head, tail) {
      const nodes = [head, ...tail];
      const cursor = parseCursor && nodes.find(node => node.type === 'cursor');
      if (cursor) {
        return {
          ...cursor,
          suggestionTypes: ['value']
        };
      }
      return (field) => buildFunctionNode('and', nodes.map(partial => partial(field)));
    };
  var peg$f14 = function(partial) {
      if (partial.type === 'cursor') {
        return {
          ...list,
          suggestionTypes: ['value']
        };
      }
      return (field) => buildFunctionNode('not', [partial(field)]);
    };
  var peg$f15 = function(value) {
      if (value.type === 'cursor') return value;
      return (field) => buildFunctionNode('is', [field, value]);
    };
  var peg$f16 = function(value) {
      if (value.type === 'cursor') return value;

      if (!allowLeadingWildcards && nodeTypes.wildcard.isNode(value) && nodeTypes.wildcard.hasLeadingWildcard(value)) {
        error('Leading wildcards are disabled. See query:allowLeadingWildcards in Advanced Settings.');
      }

      return (field) => buildFunctionNode('is', [field, value]);
    };
  var peg$f17 = function() { return parseCursor; };
  var peg$f18 = function(prefix, cursor, suffix) {
      const { start, end } = location();
      return {
        type: 'cursor',
        start: start.offset,
        end: end.offset - cursor.length,
        prefix: prefix.join(''),
        suffix: suffix.join(''),
        text: text().replace(cursor, '')
      };
    };
  var peg$f19 = function(chars) {
      return buildLiteralNode(chars.join(''), true);
    };
  var peg$f20 = function(char) { return char; };
  var peg$f21 = function(chars) {
      const sequence = chars.join('').trim();
      if (sequence === 'null') return buildLiteralNode(null);
      if (sequence === 'true') return buildLiteralNode(true);
      if (sequence === 'false') return buildLiteralNode(false);
      if (chars.includes(KQL_WILDCARD_SYMBOL)) return buildWildcardNode(sequence);
      return buildLiteralNode(sequence);
    };
  var peg$f22 = function() { return KQL_WILDCARD_SYMBOL; };
  var peg$f23 = function() { return '\t'; };
  var peg$f24 = function() { return '\r'; };
  var peg$f25 = function() { return '\n'; };
  var peg$f26 = function(keyword) { return keyword; };
  var peg$f27 = function(sequence) { return sequence; };
  var peg$f28 = function(digits) {
        return String.fromCharCode(parseInt(digits, 16));
      };
  var peg$f29 = function() { return 'lte'; };
  var peg$f30 = function() { return 'gte'; };
  var peg$f31 = function() { return 'lt'; };
  var peg$f32 = function() { return 'gt'; };
  var peg$f33 = function() { return cursorSymbol; };

  var peg$currPos = 0;
  var peg$savedPos = 0;
  var peg$posDetailsCache = [{ line: 1, column: 1 }];
  var peg$maxFailPos = 0;
  var peg$maxFailExpected = [];
  var peg$silentFails = 0;

  var peg$resultsCache = {};

  var peg$result;

  if ("startRule" in options) {
    if (!(options.startRule in peg$startRuleFunctions)) {
      throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
    }

    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
  }

  function text() {
    return input.substring(peg$savedPos, peg$currPos);
  }

  function offset() {
    return peg$savedPos;
  }

  function range() {
    return {
      source: peg$source,
      start: peg$savedPos,
      end: peg$currPos
    };
  }

  function location() {
    return peg$computeLocation(peg$savedPos, peg$currPos);
  }

  function expected(description, location) {
    location = location !== undefined
      ? location
      : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildStructuredError(
      [peg$otherExpectation(description)],
      input.substring(peg$savedPos, peg$currPos),
      location
    );
  }

  function error(message, location) {
    location = location !== undefined
      ? location
      : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildSimpleError(message, location);
  }

  function peg$literalExpectation(text, ignoreCase) {
    return { type: "literal", text: text, ignoreCase: ignoreCase };
  }

  function peg$classExpectation(parts, inverted, ignoreCase) {
    return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
  }

  function peg$anyExpectation() {
    return { type: "any" };
  }

  function peg$endExpectation() {
    return { type: "end" };
  }

  function peg$otherExpectation(description) {
    return { type: "other", description: description };
  }

  function peg$computePosDetails(pos) {
    var details = peg$posDetailsCache[pos];
    var p;

    if (details) {
      return details;
    } else {
      p = pos - 1;
      while (!peg$posDetailsCache[p]) {
        p--;
      }

      details = peg$posDetailsCache[p];
      details = {
        line: details.line,
        column: details.column
      };

      while (p < pos) {
        if (input.charCodeAt(p) === 10) {
          details.line++;
          details.column = 1;
        } else {
          details.column++;
        }

        p++;
      }

      peg$posDetailsCache[pos] = details;

      return details;
    }
  }

  function peg$computeLocation(startPos, endPos) {
    var startPosDetails = peg$computePosDetails(startPos);
    var endPosDetails = peg$computePosDetails(endPos);

    return {
      source: peg$source,
      start: {
        offset: startPos,
        line: startPosDetails.line,
        column: startPosDetails.column
      },
      end: {
        offset: endPos,
        line: endPosDetails.line,
        column: endPosDetails.column
      }
    };
  }

  function peg$fail(expected) {
    if (peg$currPos < peg$maxFailPos) { return; }

    if (peg$currPos > peg$maxFailPos) {
      peg$maxFailPos = peg$currPos;
      peg$maxFailExpected = [];
    }

    peg$maxFailExpected.push(expected);
  }

  function peg$buildSimpleError(message, location) {
    return new peg$SyntaxError(message, null, null, location);
  }

  function peg$buildStructuredError(expected, found, location) {
    return new peg$SyntaxError(
      peg$SyntaxError.buildMessage(expected, found),
      expected,
      found,
      location
    );
  }

  function peg$parsestart() {
    var s0, s1, s2, s3;

    var key = peg$currPos * 37 + 0;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseSpace();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parseSpace();
    }
    s2 = peg$parseOrQuery();
    if (s2 === peg$FAILED) {
      s2 = null;
    }
    s3 = peg$parseOptionalSpace();
    if (s3 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f0(s2, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseOrQuery() {
    var s0, s1, s2, s3, s4, s5;

    var key = peg$currPos * 37 + 1;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    s1 = peg$parseAndQuery();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parseOr();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseAndQuery();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s3;
          s3 = peg$f1(s1, s5);
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$parseOr();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseAndQuery();
            if (s5 !== peg$FAILED) {
              peg$savedPos = s3;
              s3 = peg$f1(s1, s5);
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f2(s1, s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseAndQuery();
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseAndQuery() {
    var s0, s1, s2, s3, s4, s5;

    var key = peg$currPos * 37 + 2;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    s1 = peg$parseNotQuery();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parseAnd();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseNotQuery();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s3;
          s3 = peg$f1(s1, s5);
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$parseAnd();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseNotQuery();
            if (s5 !== peg$FAILED) {
              peg$savedPos = s3;
              s3 = peg$f1(s1, s5);
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f3(s1, s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseNotQuery();
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseNotQuery() {
    var s0, s1, s2;

    var key = peg$currPos * 37 + 3;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    s1 = peg$parseNot();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseSubQuery();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f4(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseSubQuery();
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseSubQuery() {
    var s0, s1, s2, s3, s4, s5;

    var key = peg$currPos * 37 + 4;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 40) {
      s1 = peg$c0;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e0); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseSpace();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseSpace();
      }
      s3 = peg$parseOrQuery();
      if (s3 !== peg$FAILED) {
        s4 = peg$parseOptionalSpace();
        if (s4 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 41) {
            s5 = peg$c1;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e1); }
          }
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f5(s3, s4);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseNestedQuery();
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseNestedQuery() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    var key = peg$currPos * 37 + 5;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    s1 = peg$parseField();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseSpace();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseSpace();
      }
      if (input.charCodeAt(peg$currPos) === 58) {
        s3 = peg$c2;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e2); }
      }
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$parseSpace();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parseSpace();
        }
        if (input.charCodeAt(peg$currPos) === 123) {
          s5 = peg$c3;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e3); }
        }
        if (s5 !== peg$FAILED) {
          s6 = [];
          s7 = peg$parseSpace();
          while (s7 !== peg$FAILED) {
            s6.push(s7);
            s7 = peg$parseSpace();
          }
          s7 = peg$parseOrQuery();
          if (s7 !== peg$FAILED) {
            s8 = peg$parseOptionalSpace();
            if (s8 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 125) {
                s9 = peg$c4;
                peg$currPos++;
              } else {
                s9 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e4); }
              }
              if (s9 !== peg$FAILED) {
                peg$savedPos = s0;
                s0 = peg$f6(s1, s7, s8);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseExpression();
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseExpression() {
    var s0;

    var key = peg$currPos * 37 + 6;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$parseFieldRangeExpression();
    if (s0 === peg$FAILED) {
      s0 = peg$parseFieldValueExpression();
      if (s0 === peg$FAILED) {
        s0 = peg$parseValueExpression();
      }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseField() {
    var s0, s1;

    var key = peg$currPos * 37 + 7;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    peg$silentFails++;
    s0 = peg$parseLiteral();
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e5); }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseFieldRangeExpression() {
    var s0, s1, s2, s3, s4, s5;

    var key = peg$currPos * 37 + 8;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    s1 = peg$parseField();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseSpace();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseSpace();
      }
      s3 = peg$parseRangeOperator();
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$parseSpace();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parseSpace();
        }
        s5 = peg$parseLiteral();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f7(s1, s3, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseFieldValueExpression() {
    var s0, s1, s2, s3, s4, s5;

    var key = peg$currPos * 37 + 9;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    s1 = peg$parseField();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseSpace();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseSpace();
      }
      if (input.charCodeAt(peg$currPos) === 58) {
        s3 = peg$c2;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e2); }
      }
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$parseSpace();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parseSpace();
        }
        s5 = peg$parseListOfValues();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f8(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseValueExpression() {
    var s0, s1;

    var key = peg$currPos * 37 + 10;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    s1 = peg$parseValue();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f9(s1);
    }
    s0 = s1;

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseListOfValues() {
    var s0, s1, s2, s3, s4, s5;

    var key = peg$currPos * 37 + 11;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 40) {
      s1 = peg$c0;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e0); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseSpace();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseSpace();
      }
      s3 = peg$parseOrListOfValues();
      if (s3 !== peg$FAILED) {
        s4 = peg$parseOptionalSpace();
        if (s4 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 41) {
            s5 = peg$c1;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e1); }
          }
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f10(s3, s4);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseValue();
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseOrListOfValues() {
    var s0, s1, s2, s3, s4, s5;

    var key = peg$currPos * 37 + 12;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    s1 = peg$parseAndListOfValues();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parseOr();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseAndListOfValues();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s3;
          s3 = peg$f11(s1, s5);
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$parseOr();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseAndListOfValues();
            if (s5 !== peg$FAILED) {
              peg$savedPos = s3;
              s3 = peg$f11(s1, s5);
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f12(s1, s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseAndListOfValues();
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseAndListOfValues() {
    var s0, s1, s2, s3, s4, s5;

    var key = peg$currPos * 37 + 13;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    s1 = peg$parseNotListOfValues();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parseAnd();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseNotListOfValues();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s3;
          s3 = peg$f11(s1, s5);
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$parseAnd();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseNotListOfValues();
            if (s5 !== peg$FAILED) {
              peg$savedPos = s3;
              s3 = peg$f11(s1, s5);
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f13(s1, s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseNotListOfValues();
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseNotListOfValues() {
    var s0, s1, s2;

    var key = peg$currPos * 37 + 14;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    s1 = peg$parseNot();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseListOfValues();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f14(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseListOfValues();
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseValue() {
    var s0, s1;

    var key = peg$currPos * 37 + 15;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseQuotedString();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f15(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseUnquotedLiteral();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f16(s1);
      }
      s0 = s1;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e6); }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseOr() {
    var s0, s1, s2, s3, s4;

    var key = peg$currPos * 37 + 16;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseSpace();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseSpace();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 2).toLowerCase() === peg$c5) {
        s2 = input.substr(peg$currPos, 2);
        peg$currPos += 2;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e8); }
      }
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parseSpace();
        if (s4 !== peg$FAILED) {
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseSpace();
          }
        } else {
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e7); }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseAnd() {
    var s0, s1, s2, s3, s4;

    var key = peg$currPos * 37 + 17;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseSpace();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseSpace();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 3).toLowerCase() === peg$c6) {
        s2 = input.substr(peg$currPos, 3);
        peg$currPos += 3;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e10); }
      }
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parseSpace();
        if (s4 !== peg$FAILED) {
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseSpace();
          }
        } else {
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e9); }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseNot() {
    var s0, s1, s2, s3;

    var key = peg$currPos * 37 + 18;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c7) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e12); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseSpace();
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e11); }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseLiteral() {
    var s0, s1;

    var key = peg$currPos * 37 + 19;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    peg$silentFails++;
    s0 = peg$parseQuotedString();
    if (s0 === peg$FAILED) {
      s0 = peg$parseUnquotedLiteral();
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e13); }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseQuotedString() {
    var s0, s1, s2, s3, s4, s5, s6;

    var key = peg$currPos * 37 + 20;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    peg$savedPos = peg$currPos;
    s1 = peg$f17();
    if (s1) {
      s1 = undefined;
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 34) {
        s2 = peg$c8;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e14); }
      }
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parseQuotedCharacter();
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parseQuotedCharacter();
        }
        s4 = peg$parseCursor();
        if (s4 !== peg$FAILED) {
          s5 = [];
          s6 = peg$parseQuotedCharacter();
          while (s6 !== peg$FAILED) {
            s5.push(s6);
            s6 = peg$parseQuotedCharacter();
          }
          if (input.charCodeAt(peg$currPos) === 34) {
            s6 = peg$c8;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e14); }
          }
          if (s6 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f18(s3, s4, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 34) {
        s1 = peg$c8;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e14); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseQuotedCharacter();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseQuotedCharacter();
        }
        if (input.charCodeAt(peg$currPos) === 34) {
          s3 = peg$c8;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e14); }
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f19(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseQuotedCharacter() {
    var s0, s1, s2;

    var key = peg$currPos * 37 + 21;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$parseEscapedWhitespace();
    if (s0 === peg$FAILED) {
      s0 = peg$parseEscapedUnicodeSequence();
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 92) {
          s1 = peg$c9;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e15); }
        }
        if (s1 !== peg$FAILED) {
          if (peg$r0.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e16); }
          }
          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f20(s2);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$currPos;
          peg$silentFails++;
          s2 = peg$parseCursor();
          peg$silentFails--;
          if (s2 === peg$FAILED) {
            s1 = undefined;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
          if (s1 !== peg$FAILED) {
            if (peg$r1.test(input.charAt(peg$currPos))) {
              s2 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e17); }
            }
            if (s2 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f20(s2);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        }
      }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseUnquotedLiteral() {
    var s0, s1, s2, s3, s4, s5;

    var key = peg$currPos * 37 + 22;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    peg$savedPos = peg$currPos;
    s1 = peg$f17();
    if (s1) {
      s1 = undefined;
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseUnquotedCharacter();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseUnquotedCharacter();
      }
      s3 = peg$parseCursor();
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$parseUnquotedCharacter();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parseUnquotedCharacter();
        }
        peg$savedPos = s0;
        s0 = peg$f18(s2, s3, s4);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseUnquotedCharacter();
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseUnquotedCharacter();
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f21(s1);
      }
      s0 = s1;
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseUnquotedCharacter() {
    var s0, s1, s2, s3, s4;

    var key = peg$currPos * 37 + 23;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$parseEscapedWhitespace();
    if (s0 === peg$FAILED) {
      s0 = peg$parseEscapedSpecialCharacter();
      if (s0 === peg$FAILED) {
        s0 = peg$parseEscapedUnicodeSequence();
        if (s0 === peg$FAILED) {
          s0 = peg$parseEscapedKeyword();
          if (s0 === peg$FAILED) {
            s0 = peg$parseWildcard();
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$currPos;
              peg$silentFails++;
              s2 = peg$parseSpecialCharacter();
              peg$silentFails--;
              if (s2 === peg$FAILED) {
                s1 = undefined;
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }
              if (s1 !== peg$FAILED) {
                s2 = peg$currPos;
                peg$silentFails++;
                s3 = peg$parseKeyword();
                peg$silentFails--;
                if (s3 === peg$FAILED) {
                  s2 = undefined;
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
                if (s2 !== peg$FAILED) {
                  s3 = peg$currPos;
                  peg$silentFails++;
                  s4 = peg$parseCursor();
                  peg$silentFails--;
                  if (s4 === peg$FAILED) {
                    s3 = undefined;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                  if (s3 !== peg$FAILED) {
                    if (input.length > peg$currPos) {
                      s4 = input.charAt(peg$currPos);
                      peg$currPos++;
                    } else {
                      s4 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e18); }
                    }
                    if (s4 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s0 = peg$f20(s4);
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            }
          }
        }
      }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseWildcard() {
    var s0, s1;

    var key = peg$currPos * 37 + 24;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 42) {
      s1 = peg$c10;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e19); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f22();
    }
    s0 = s1;

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseOptionalSpace() {
    var s0, s1, s2, s3, s4, s5;

    var key = peg$currPos * 37 + 25;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    peg$savedPos = peg$currPos;
    s1 = peg$f17();
    if (s1) {
      s1 = undefined;
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseSpace();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseSpace();
      }
      s3 = peg$parseCursor();
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$parseSpace();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parseSpace();
        }
        peg$savedPos = s0;
        s0 = peg$f18(s2, s3, s4);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = [];
      s1 = peg$parseSpace();
      while (s1 !== peg$FAILED) {
        s0.push(s1);
        s1 = peg$parseSpace();
      }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseEscapedWhitespace() {
    var s0, s1;

    var key = peg$currPos * 37 + 26;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c11) {
      s1 = peg$c11;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e20); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f23();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 2) === peg$c12) {
        s1 = peg$c12;
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e21); }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f24();
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c13) {
          s1 = peg$c13;
          peg$currPos += 2;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e22); }
        }
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$f25();
        }
        s0 = s1;
      }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseEscapedSpecialCharacter() {
    var s0, s1, s2;

    var key = peg$currPos * 37 + 27;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 92) {
      s1 = peg$c9;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e15); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseSpecialCharacter();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f20(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseEscapedKeyword() {
    var s0, s1, s2;

    var key = peg$currPos * 37 + 28;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 92) {
      s1 = peg$c9;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e15); }
    }
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 2).toLowerCase() === peg$c5) {
        s2 = input.substr(peg$currPos, 2);
        peg$currPos += 2;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e8); }
      }
      if (s2 === peg$FAILED) {
        if (input.substr(peg$currPos, 3).toLowerCase() === peg$c6) {
          s2 = input.substr(peg$currPos, 3);
          peg$currPos += 3;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e10); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 3).toLowerCase() === peg$c7) {
            s2 = input.substr(peg$currPos, 3);
            peg$currPos += 3;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e12); }
          }
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f26(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseKeyword() {
    var s0;

    var key = peg$currPos * 37 + 29;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$parseOr();
    if (s0 === peg$FAILED) {
      s0 = peg$parseAnd();
      if (s0 === peg$FAILED) {
        s0 = peg$parseNot();
      }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseSpecialCharacter() {
    var s0;

    var key = peg$currPos * 37 + 30;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    if (peg$r2.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e23); }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseEscapedUnicodeSequence() {
    var s0, s1, s2;

    var key = peg$currPos * 37 + 31;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 92) {
      s1 = peg$c9;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e15); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseUnicodeSequence();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f27(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseUnicodeSequence() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    var key = peg$currPos * 37 + 32;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 117) {
      s1 = peg$c14;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e24); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$currPos;
      s4 = peg$parseHexDigit();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseHexDigit();
        if (s5 !== peg$FAILED) {
          s6 = peg$parseHexDigit();
          if (s6 !== peg$FAILED) {
            s7 = peg$parseHexDigit();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        s2 = input.substring(s2, peg$currPos);
      } else {
        s2 = s3;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f28(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseHexDigit() {
    var s0;

    var key = peg$currPos * 37 + 33;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    if (peg$r3.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e25); }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseRangeOperator() {
    var s0, s1;

    var key = peg$currPos * 37 + 34;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c15) {
      s1 = peg$c15;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e26); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f29();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 2) === peg$c16) {
        s1 = peg$c16;
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e27); }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f30();
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 60) {
          s1 = peg$c17;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e28); }
        }
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$f31();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 62) {
            s1 = peg$c18;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e29); }
          }
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$f32();
          }
          s0 = s1;
        }
      }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseSpace() {
    var s0, s1;

    var key = peg$currPos * 37 + 35;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    peg$silentFails++;
    if (peg$r4.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e31); }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e30); }
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }

  function peg$parseCursor() {
    var s0, s1, s2;

    var key = peg$currPos * 37 + 36;
    var cached = peg$resultsCache[key];

    if (cached) {
      peg$currPos = cached.nextPos;

      return cached.result;
    }

    s0 = peg$currPos;
    peg$savedPos = peg$currPos;
    s1 = peg$f17();
    if (s1) {
      s1 = undefined;
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 14) === peg$c19) {
        s2 = peg$c19;
        peg$currPos += 14;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e32); }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f33();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };

    return s0;
  }


    const { parseCursor, cursorSymbol, allowLeadingWildcards = true, helpers: { nodeTypes } } = options;
    const buildFunctionNode = nodeTypes.function.buildNodeWithArgumentNodes;
    const buildLiteralNode = nodeTypes.literal.buildNode;
    const buildWildcardNode = nodeTypes.wildcard.buildNode;
    const { KQL_WILDCARD_SYMBOL } = nodeTypes.wildcard;


  peg$result = peg$startRuleFunction();

  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
    return peg$result;
  } else {
    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
      peg$fail(peg$endExpectation());
    }

    throw peg$buildStructuredError(
      peg$maxFailExpected,
      peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
      peg$maxFailPos < input.length
        ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
        : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
    );
  }
}

module.exports = {
  SyntaxError: peg$SyntaxError,
  parse: peg$parse
};
