"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.instanceAsFilter = instanceAsFilter;
var _lodash = require("lodash");
var _source_definition = require("./source_definition");
var _unknown_entity_type = require("../errors/unknown_entity_type");
var _invalid_entity_instance = require("../errors/invalid_entity_instance");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function instanceAsFilter(instance, clusterClient, logger) {
  const sources = await (0, _source_definition.readSourceDefinitions)(clusterClient, logger, {
    type: instance['entity.type']
  });
  if (sources.length === 0) {
    throw new _unknown_entity_type.UnknownEntityType(`No sources found for type ${instance['entity.type']}`);
  }
  const sourceFilters = (0, _lodash.compact)(sources.map(source => {
    const {
      identity_fields: identityFields
    } = source;
    const instanceHasRequiredFields = identityFields.every(identityField => instance[identityField] ? true : false);
    if (!instanceHasRequiredFields) {
      return undefined;
    }
    const fieldFilters = identityFields.map(identityField => `${identityField}: "${instance[identityField]}"`);
    return `(${fieldFilters.join(' AND ')})`;
  }));
  if (sourceFilters.length === 0) {
    throw new _invalid_entity_instance.InvalidEntityInstance(`Entity ${instance['entity.id']} of type ${instance['entity.type']} is missing some identity fields, no sources could match`);
  }
  return sourceFilters.join(' OR ');
}