"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.builtInServicesFromEcsEntityDefinition = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const builtInServicesFromEcsEntityDefinition = exports.builtInServicesFromEcsEntityDefinition = {
  type: {
    id: `${_constants.BUILT_IN_ID_PREFIX}services_from_ecs_data`,
    display_name: 'Services'
  },
  sources: [{
    id: `${_constants.BUILT_IN_ID_PREFIX}services_from_ecs_data_ecs`,
    type_id: `${_constants.BUILT_IN_ID_PREFIX}services_from_ecs_data`,
    index_patterns: ['logs-*', 'filebeat*', 'traces-*'],
    identity_fields: ['service.name'],
    display_name: 'service.name',
    timestamp_field: '@timestamp',
    metadata_fields: [],
    filters: []
  }]
};