"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _serverRouteRepositoryClient = require("@kbn/server-route-repository-client");
var _esQuery = require("@kbn/es-query");
var _errors = require("./errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EntityClient {
  constructor(core) {
    (0, _defineProperty2.default)(this, "repositoryClient", void 0);
    this.repositoryClient = (0, _serverRouteRepositoryClient.createRepositoryClient)(core).fetch;
  }
  async isManagedEntityDiscoveryEnabled() {
    return await this.repositoryClient('GET /internal/entities/managed/enablement');
  }
  async enableManagedEntityDiscovery(query) {
    try {
      return await this.repositoryClient('PUT /internal/entities/managed/enablement', {
        params: {
          query: {
            installOnly: query === null || query === void 0 ? void 0 : query.installOnly
          }
        }
      });
    } catch (err) {
      var _err$body;
      if ((0, _serverRouteRepositoryClient.isHttpFetchError)(err) && ((_err$body = err.body) === null || _err$body === void 0 ? void 0 : _err$body.statusCode) === 403) {
        throw new _errors.EntityManagerUnauthorizedError(err.body.message);
      }
      throw err;
    }
  }
  async disableManagedEntityDiscovery(query) {
    try {
      return await this.repositoryClient('DELETE /internal/entities/managed/enablement', {
        params: {
          query: {
            deleteData: query === null || query === void 0 ? void 0 : query.deleteData
          }
        }
      });
    } catch (err) {
      var _err$body2;
      if ((0, _serverRouteRepositoryClient.isHttpFetchError)(err) && ((_err$body2 = err.body) === null || _err$body2 === void 0 ? void 0 : _err$body2.statusCode) === 403) {
        throw new _errors.EntityManagerUnauthorizedError(err.body.message);
      }
      throw err;
    }
  }
  async getEntityDefinition(id) {
    try {
      return await this.repositoryClient('GET /internal/entities/definition/{id?}', {
        params: {
          path: {
            id
          },
          query: {
            page: 1,
            perPage: 1
          }
        }
      });
    } catch (err) {
      var _err$body3;
      if ((0, _serverRouteRepositoryClient.isHttpFetchError)(err) && ((_err$body3 = err.body) === null || _err$body3 === void 0 ? void 0 : _err$body3.statusCode) === 403) {
        throw new _errors.EntityManagerUnauthorizedError(err.body.message);
      }
      throw err;
    }
  }
  asKqlFilter({
    entity
  }) {
    const identityFieldsValue = this.getIdentityFieldsValue({
      entity
    });
    const nodes = Object.entries(identityFieldsValue).map(([identityField, value]) => {
      return _esQuery.nodeTypes.function.buildNode('is', identityField, `"${value}"`);
    });
    if (nodes.length === 0) return '';
    const kqlExpression = nodes.length > 1 ? _esQuery.nodeTypes.function.buildNode('and', nodes) : nodes[0];
    return (0, _esQuery.toKqlExpression)(kqlExpression);
  }
  getIdentityFieldsValue({
    entity
  }) {
    const {
      entityIdentityFields: identityFields
    } = entity;
    if (!Object.keys(identityFields || {}).length) {
      throw new Error('Identity fields are missing');
    }
    return Object.values(identityFields).reduce((acc, fields) => {
      fields.forEach(field => {
        if (entity !== null && entity !== void 0 && entity[field]) {
          acc[field] = entity[field];
        }
      });
      return acc;
    }, {});
  }
}
exports.EntityClient = EntityClient;