"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityManagerOverviewPage = EntityManagerOverviewPage;
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _use_plugin_context = require("../../hooks/use_plugin_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EntitySourceForm({
  source,
  index,
  onFieldChange
}) {
  const onArrayFieldChange = field => e => {
    const value = e.target.value.trim();
    if (!value) {
      onFieldChange(index, field, []);
    } else {
      onFieldChange(index, field, e.target.value.trim().split(','));
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Index patterns (comma-separated)"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "entityManagerFormIndexPatterns",
    name: "index_patterns",
    defaultValue: source.index_patterns.join(','),
    isInvalid: source.index_patterns.length === 0,
    onChange: onArrayFieldChange('index_patterns')
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Identify fields (comma-separated field names)"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "entityManagerFormIdentityFields",
    name: "identity_fields",
    defaultValue: source.identity_fields.join(','),
    isInvalid: source.identity_fields.length === 0,
    onChange: onArrayFieldChange('identity_fields')
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Filters (comma-separated KQL filters)"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "entityManagerFormFilters",
    name: "filters",
    defaultValue: source.filters.join(','),
    onChange: onArrayFieldChange('filters')
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Metadata (comma-separated field names)"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "entityManagerFormMetadata",
    name: "metadata",
    defaultValue: source.metadata_fields.join(','),
    onChange: onArrayFieldChange('metadata_fields')
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Timestamp field"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "entityManagerFormTimestamp",
    name: "timestamp_field",
    defaultValue: source.timestamp_field,
    onChange: e => onFieldChange(index, 'timestamp_field', e.target.value)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Display name"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "entityManagerFormDisplayName",
    name: "display_name",
    defaultValue: source.display_name,
    onChange: e => onFieldChange(index, 'display_name', e.target.value)
  }))));
}
const newEntitySource = ({
  indexPatterns = [],
  identityFields = [],
  metadataFields = [],
  filters = [],
  timestampField = '@timestamp'
}) => ({
  id: (0, _uuid.v4)(),
  index_patterns: indexPatterns,
  identity_fields: identityFields,
  metadata_fields: metadataFields,
  timestamp_field: timestampField,
  filters
});
function EntityManagerOverviewPage() {
  const {
    ObservabilityPageTemplate,
    entityClient
  } = (0, _use_plugin_context.usePluginContext)();
  const [previewEntities, setPreviewEntities] = (0, _react.useState)([]);
  const [isSearchingEntities, setIsSearchingEntities] = (0, _react.useState)(false);
  const [previewError, setPreviewError] = (0, _react.useState)(null);
  const [formErrors, setFormErrors] = (0, _react.useState)([]);
  const [entityType, setEntityType] = (0, _react.useState)('service');
  const [entitySources, setEntitySources] = (0, _react.useState)([newEntitySource({
    indexPatterns: ['remote_cluster:logs-*'],
    identityFields: ['service.name']
  })]);
  const searchEntities = async () => {
    if (!entitySources.some(source => source.identity_fields.length > 0 && source.index_patterns.length > 0)) {
      setFormErrors(['No valid source found']);
      return;
    }
    setIsSearchingEntities(true);
    setFormErrors([]);
    setPreviewError(null);
    try {
      const {
        entities
      } = await entityClient.repositoryClient('POST /internal/entities/v2/_search/preview', {
        params: {
          body: {
            sources: entitySources.filter(source => source.index_patterns.length > 0 && source.identity_fields.length > 0).map(source => ({
              ...source,
              type_id: entityType
            }))
          }
        }
      });
      setPreviewEntities(entities);
    } catch (err) {
      var _err$body;
      setPreviewError((_err$body = err.body) === null || _err$body === void 0 ? void 0 : _err$body.message);
    } finally {
      setIsSearchingEntities(false);
    }
  };
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "entitiesPage",
    pageHeader: {
      bottomBorder: true,
      pageTitle: 'Entity Manager'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    isInvalid: formErrors.length > 0,
    error: formErrors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, "Entity type"))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "entityManagerFormType",
    name: "type",
    defaultValue: entityType,
    placeholder: "host, service, user...",
    onChange: e => {
      setEntityType(e.target.value.trim());
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, "Entity sources"))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "entityManagerFormAddSource",
    iconType: "plusInCircle",
    onClick: () => setEntitySources([...entitySources, newEntitySource({})])
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), entitySources.map((source, i) => /*#__PURE__*/_react.default.createElement("div", {
    key: source.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, "Source ", i + 1))), entitySources.length > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "entityManagerFormRemoveSource",
    color: 'danger',
    iconType: 'minusInCircle',
    onClick: () => {
      entitySources.splice(i, 1);
      setEntitySources(entitySources.map(_source => ({
        ..._source
      })));
    }
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(EntitySourceForm, {
    source: source,
    index: i,
    onFieldChange: (index, field, value) => {
      entitySources[index][field] = value;
      setEntitySources([...entitySources]);
    }
  }), i === entitySources.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entityManagerFormPreview",
    isDisabled: isSearchingEntities,
    onClick: searchEntities
  }, "Preview")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entityManagerFormCreate",
    isDisabled: true,
    color: "primary"
  }, "Create"))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), previewError ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Error previewing entity definition",
    color: "danger",
    iconType: "error"
  }, /*#__PURE__*/_react.default.createElement("p", null, previewError)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: isSearchingEntities,
    tableCaption: 'Preview entities',
    items: previewEntities,
    columns: [{
      field: 'entity.id',
      name: 'entity.id'
    }, {
      field: 'entity.display_name',
      name: 'entity.display_name'
    }, {
      field: 'entity.type',
      name: 'entity.type'
    }, {
      field: 'entity.last_seen_timestamp',
      name: 'entity.last_seen_timestamp'
    }, ...Array.from(new Set(entitySources.flatMap(source => source.identity_fields))).map(field => ({
      field,
      name: field
    })), ...Array.from(new Set(entitySources.flatMap(source => source.metadata_fields))).map(field => ({
      field,
      name: field
    }))]
  }));
}