"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDeprecationRoutes = registerDeprecationRoutes;
var _configSchema = require("@kbn/config-schema");
var _searchConnectors = require("@kbn/search-connectors");
var _elasticsearch_error_handler = require("../../utils/elasticsearch_error_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerDeprecationRoutes({
  router,
  log
}) {
  router.post({
    path: '/internal/enterprise_search/deprecations/delete_crawler_connectors',
    validate: {
      body: _configSchema.schema.object({
        ids: _configSchema.schema.arrayOf(_configSchema.schema.string()),
        deprecationDetails: _configSchema.schema.object({
          domainId: _configSchema.schema.literal('enterpriseSearch')
        })
      })
    }
  }, (0, _elasticsearch_error_handler.elasticsearchErrorHandler)(log, async (context, request, response) => {
    const {
      client
    } = (await context.core).elasticsearch;
    await Promise.all(request.body.ids.map(connectorId => (0, _searchConnectors.deleteConnectorById)(client.asCurrentUser, connectorId)));
    return response.ok({
      body: {
        deleted: request.body.ids
      },
      headers: {
        'content-type': 'application/json'
      }
    });
  }));
  router.post({
    path: '/internal/enterprise_search/deprecations/convert_connectors_to_client',
    validate: {
      body: _configSchema.schema.object({
        ids: _configSchema.schema.arrayOf(_configSchema.schema.string()),
        deprecationDetails: _configSchema.schema.object({
          domainId: _configSchema.schema.literal('enterpriseSearch')
        })
      })
    }
  }, (0, _elasticsearch_error_handler.elasticsearchErrorHandler)(log, async (context, request, response) => {
    const {
      client
    } = (await context.core).elasticsearch;
    await Promise.all(request.body.ids.map(connectorId => (0, _searchConnectors.putUpdateNative)(client.asCurrentUser, connectorId, false)));
    return response.ok({
      body: {
        converted_to_client: request.body.ids
      },
      headers: {
        'content-type': 'application/json'
      }
    });
  }));
}