"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecentActivityItem = exports.RecentActivity = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _telemetry = require("../../../shared/telemetry");
var _app_logic = require("../../app_logic");
var _content_section = require("../../components/shared/content_section");
var _constants = require("../../constants");
var _routes = require("../../routes");
var _overview_logic = require("./overview_logic");
require("./recent_activity.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RecentActivity = () => {
  const {
    organization: {
      name,
      defaultOrgName
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    activityFeed
  } = (0, _kea.useValues)(_overview_logic.OverviewLogic);
  return /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, {
    title: _constants.RECENT_ACTIVITY_TITLE,
    headerSpacer: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false
  }, activityFeed.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, activityFeed.map((props, index) => /*#__PURE__*/_react.default.createElement(RecentActivityItem, (0, _extends2.default)({}, props, {
    key: index
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "clock",
    iconColor: "subdued",
    titleSize: "s",
    title: /*#__PURE__*/_react.default.createElement("h3", null, name === defaultOrgName ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.workplaceSearch.activityFeedEmptyDefault.title",
      defaultMessage: "Your organization has no recent activity"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.workplaceSearch.activityFeedNamedDefault.title",
      defaultMessage: "{name} has no recent activity",
      values: {
        name
      }
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }))));
};
exports.RecentActivity = RecentActivity;
const RecentActivityItem = ({
  id,
  status,
  message,
  timestamp,
  sourceId
}) => {
  const {
    sendWorkplaceSearchTelemetry
  } = (0, _kea.useActions)(_telemetry.TelemetryLogic);
  const onClick = () => sendWorkplaceSearchTelemetry({
    action: 'clicked',
    metric: 'recent_activity_source_details_link'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `activity ${status ? `activity--${status}` : ''}`
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "activity__message"
  }, sourceId ? /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    onClick: onClick,
    color: status === 'error' ? 'danger' : 'primary',
    to: (0, _routes.getContentSourcePath)(_routes.SOURCE_DETAILS_PATH, sourceId, true),
    "data-test-subj": "viewSourceDetailsLink"
  }, id, " ", message, status === 'error' && /*#__PURE__*/_react.default.createElement("span", {
    className: "activity--error__label"
  }, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.recentActivitySourceLink.linkLabel",
    defaultMessage: "View Source"
  }))) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "newUserTextWrapper"
  }, id, " ", message)), /*#__PURE__*/_react.default.createElement("div", {
    className: "activity__date"
  }, _moment.default.utc(timestamp).fromNow()));
};
exports.RecentActivityItem = RecentActivityItem;