"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildBaseClassicNavItems = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _deeplinksSearch = require("@kbn/deeplinks-search");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildBaseClassicNavItems = ({
  productAccess
}) => {
  const navItems = [];

  // Home
  navItems.push({
    'data-test-subj': 'searchSideNav-Home',
    deepLink: {
      link: _deeplinksSearch.ENTERPRISE_SEARCH_APP_ID,
      shouldShowActiveForSubroutes: true
    },
    id: 'home',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.nav.homeTitle', {
      defaultMessage: 'Home'
    }))
  });

  // Content
  navItems.push({
    'data-test-subj': 'searchSideNav-Content',
    id: 'content',
    items: [{
      'data-test-subj': 'searchSideNav-Indices',
      deepLink: {
        link: 'enterpriseSearchContent:searchIndices',
        shouldShowActiveForSubroutes: true
      },
      id: 'search_indices'
    }, {
      'data-test-subj': 'searchSideNav-Connectors',
      deepLink: {
        link: 'enterpriseSearchContent:connectors',
        shouldShowActiveForSubroutes: true
      },
      id: 'connectors'
    }, {
      'data-test-subj': 'searchSideNav-Crawlers',
      deepLink: {
        link: 'enterpriseSearchContent:webCrawlers',
        shouldShowActiveForSubroutes: true
      },
      id: 'crawlers'
    }],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.contentTitle', {
      defaultMessage: 'Content'
    })
  });

  // Build
  navItems.push({
    'data-test-subj': 'searchSideNav-Build',
    id: 'build',
    items: [{
      'data-test-subj': 'searchSideNav-Playground',
      deepLink: {
        link: 'searchPlayground',
        shouldShowActiveForSubroutes: true
      },
      id: 'playground'
    }, {
      'data-test-subj': 'searchSideNav-SearchApplications',
      deepLink: {
        link: 'enterpriseSearchApplications:searchApplications'
      },
      id: 'searchApplications'
    }, {
      'data-test-subj': 'searchSideNav-BehavioralAnalytics',
      deepLink: {
        link: _deeplinksSearch.ENTERPRISE_SEARCH_ANALYTICS_APP_ID
      },
      id: 'analyticsCollections'
    }],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.applicationsTitle', {
      defaultMessage: 'Build'
    })
  });
  navItems.push({
    'data-test-subj': 'searchSideNav-Relevance',
    id: 'relevance',
    items: [{
      'data-test-subj': 'searchSideNav-InferenceEndpoints',
      deepLink: {
        link: 'searchInferenceEndpoints:inferenceEndpoints',
        shouldShowActiveForSubroutes: true
      },
      id: 'inference_endpoints'
    }, {
      'data-test-subj': 'searchSideNav-Synonyms',
      deepLink: {
        link: 'searchSynonyms:synonyms',
        shouldShowActiveForSubroutes: true
      },
      id: 'synonyms'
    }],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.relevanceTitle', {
      defaultMessage: 'Relevance'
    })
  });

  // Getting Started
  navItems.push({
    'data-test-subj': 'searchSideNav-GettingStarted',
    id: 'es_getting_started',
    items: [{
      'data-test-subj': 'searchSideNav-Elasticsearch',
      deepLink: {
        link: _deeplinksSearch.SEARCH_ELASTICSEARCH
      },
      id: 'elasticsearch'
    }, {
      'data-test-subj': 'searchSideNav-VectorSearch',
      deepLink: {
        link: _deeplinksSearch.SEARCH_VECTOR_SEARCH
      },
      id: 'vectorSearch'
    }, {
      'data-test-subj': 'searchSideNav-SemanticSearch',
      deepLink: {
        link: _deeplinksSearch.SEARCH_SEMANTIC_SEARCH
      },
      id: 'semanticSearch'
    }, {
      'data-test-subj': 'searchSideNav-AISearch',
      deepLink: {
        link: _deeplinksSearch.SEARCH_AI_SEARCH
      },
      id: 'aiSearch'
    }],
    name: _constants.GETTING_STARTED_TITLE
  });
  if (productAccess.hasAppSearchAccess || productAccess.hasWorkplaceSearchAccess) {
    const entSearchItems = [];
    if (productAccess.hasAppSearchAccess) {
      entSearchItems.push({
        'data-test-subj': 'searchSideNav-AppSearch',
        deepLink: {
          link: 'appSearch:engines'
        },
        name: _constants.APP_SEARCH_PLUGIN.NAME,
        id: 'app_search'
      });
    }
    if (productAccess.hasWorkplaceSearchAccess) {
      entSearchItems.push({
        'data-test-subj': 'searchSideNav-WorkplaceSearch',
        deepLink: {
          link: 'workplaceSearch'
        },
        id: 'workplace_search'
      });
    }
    navItems.push({
      'data-test-subj': 'searchSideNav-EnterpriseSearch',
      id: 'enterpriseSearch',
      items: entSearchItems,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.title', {
        defaultMessage: 'Enterprise Search'
      })
    });
  }
  return navItems;
};
exports.buildBaseClassicNavItems = buildBaseClassicNavItems;