"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SAVE_LABEL = exports.EDIT_LABEL = exports.CreateApiKeyFlyout = exports.CANCEL_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../common/types/api");
var _create_elasticsearch_api_key_logic = require("../../enterprise_search_overview/api/create_elasticsearch_api_key_logic");
var _kibana = require("../kibana");
var _basic_setup_form = require("./basic_setup_form");
var _metadata_form = require("./metadata_form");
var _security_privileges_form = require("./security_privileges_form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ROLE_DESCRIPTORS = `{
  "enterprise_search": {
    "indices": [{
      "names": ["*"],
      "privileges": [
        "all"
      ]
    }]
  }
}`;
const DEFAULT_METADATA = `{
  "application": "myapp"
}`;
const CANCEL_LABEL = exports.CANCEL_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.cancel', {
  defaultMessage: 'Cancel'
});
const EDIT_LABEL = exports.EDIT_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.edit', {
  defaultMessage: 'Edit'
});
const SAVE_LABEL = exports.SAVE_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.save', {
  defaultMessage: 'Save'
});
const REQUIRED_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.required', {
  defaultMessage: 'Required'
});
const ENABLED_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.enabled', {
  defaultMessage: 'Enabled'
});
const DISABLED_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.disabled', {
  defaultMessage: 'Disabled'
});
const INVALID_JSON_ERROR = _i18n.i18n.translate('xpack.enterpriseSearch.invalidJsonError', {
  defaultMessage: 'Invalid JSON'
});
const CreateApiKeyFlyout = ({
  onClose
}) => {
  var _error$body;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [name, setName] = (0, _react.useState)('');
  const [expires, setExpires] = (0, _react.useState)(_basic_setup_form.DEFAULT_EXPIRES_VALUE);
  const [roleDescriptors, setRoleDescriptors] = (0, _react.useState)(DEFAULT_ROLE_DESCRIPTORS);
  const [roleDescriptorsError, setRoleDescriptorsError] = (0, _react.useState)(undefined);
  const [metadata, setMetadata] = (0, _react.useState)(DEFAULT_METADATA);
  const [metadataError, setMetadataError] = (0, _react.useState)(undefined);
  const [privilegesEnabled, setPrivilegesEnabled] = (0, _react.useState)(false);
  const [privilegesOpen, setPrivilegesOpen] = (0, _react.useState)('closed');
  const [metadataEnabled, setMetadataEnabled] = (0, _react.useState)(false);
  const [metadataOpen, setMetadataOpen] = (0, _react.useState)('closed');
  const {
    user
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    makeRequest: saveApiKey,
    apiReset
  } = (0, _kea.useActions)(_create_elasticsearch_api_key_logic.CreateApiKeyAPILogic);
  const {
    data: createdApiKey,
    error,
    status
  } = (0, _kea.useValues)(_create_elasticsearch_api_key_logic.CreateApiKeyAPILogic);
  const isLoading = status === _api.Status.LOADING;
  const username = (user === null || user === void 0 ? void 0 : user.full_name) || (user === null || user === void 0 ? void 0 : user.username) || (user === null || user === void 0 ? void 0 : user.email) || '';
  const togglePrivileges = e => {
    const enabled = e.target.checked;
    setPrivilegesEnabled(enabled);
    setPrivilegesOpen(enabled ? 'open' : 'closed');
    // Reset role descriptors to default
    if (enabled) setRoleDescriptors(DEFAULT_ROLE_DESCRIPTORS);
  };
  const toggleMetadata = e => {
    const enabled = e.target.checked;
    setMetadataEnabled(enabled);
    setMetadataOpen(enabled ? 'open' : 'closed');
    // Reset metadata to default
    if (enabled) setMetadata(DEFAULT_METADATA);
  };
  const onCreateClick = () => {
    let parsedRoleDescriptors;
    if (privilegesEnabled) {
      try {
        parsedRoleDescriptors = roleDescriptors.length > 0 ? JSON.parse(roleDescriptors) : undefined;
      } catch (e) {
        setRoleDescriptorsError(INVALID_JSON_ERROR);
        return;
      }
    }
    if (roleDescriptorsError) setRoleDescriptorsError(undefined);
    let parsedMetadata;
    if (metadataEnabled) {
      try {
        parsedMetadata = metadata.length > 0 ? JSON.parse(metadata) : undefined;
      } catch (e) {
        setMetadataError(INVALID_JSON_ERROR);
        return;
      }
    }
    if (metadataError) setMetadataError(undefined);
    const expiration = expires !== null ? `${expires}d` : undefined;
    saveApiKey({
      expiration,
      metadata: parsedMetadata,
      name,
      role_descriptors: parsedRoleDescriptors
    });
  };
  const apiKeyRef = (0, _react.useRef)(null);
  const uniqueId = (0, _eui.useGeneratedHtmlId)();
  (0, _react.useEffect)(() => {
    if (createdApiKey && apiKeyRef) {
      var _apiKeyRef$current;
      (_apiKeyRef$current = apiKeyRef.current) === null || _apiKeyRef$current === void 0 ? void 0 : _apiKeyRef$current.scrollIntoView();
    }
  }, [createdApiKey, apiKeyRef]);
  const closeFlyOut = () => {
    apiReset();
    onClose();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyOut,
    css: (0, _react2.css)`
        max-width: calc(${euiTheme.size.xxxxl} * 10);
      `,
    "aria-labelledby": `${uniqueId}-header`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: `${uniqueId}-header`
  }, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.flyoutTitle', {
    defaultMessage: 'Create an API key'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement("div", {
    ref: apiKeyRef
  }), createdApiKey && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "success",
    "data-test-subj": "api-key-create-success-panel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStep, {
    css: (0, _react2.css)`
                  .euiStep__content {
                    padding-bottom: 0;
                  }
                `,
    status: "complete",
    headingElement: "h3",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.apiKeyStepTitle', {
      defaultMessage: 'Store this API key'
    }),
    titleSize: "xs",
    role: "alert"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.apiKeyStepDescription', {
    defaultMessage: "You'll only see this key once, so save it somewhere safe. We don't store your API keys, so if you lose a key you'll need to generate a replacement."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    "data-test-subj": "api-key-created-key-codeblock"
  }, JSON.stringify(createdApiKey, undefined, 2)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), error && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.flyout.errorTitle', {
      defaultMessage: 'Error creating API key'
    }),
    "data-test-subj": "create-api-key-error-callout"
  }, (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "apiKey.setup",
    paddingSize: "l",
    initialIsOpen: true,
    "aria-labelledby": `${uniqueId}-setupHeader`,
    role: "region",
    buttonContent: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "gear"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", {
      id: `${uniqueId}-setupHeader`
    }, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.setup.title', {
      defaultMessage: 'Setup'
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.setup.description', {
      defaultMessage: 'Basic configuration details to create your API key.'
    })))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, REQUIRED_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_basic_setup_form.BasicSetupForm, {
    isLoading: isLoading,
    name: name,
    user: username,
    expires: expires,
    onChangeName: newName => setName(newName),
    onChangeExpires: newExpires => setExpires(newExpires)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "apiKey.privileges",
    paddingSize: "l",
    role: "region",
    "aria-labelledby": `${uniqueId}-privilegesHeader`,
    buttonContent: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        paddingRight: euiTheme.size.s
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "lock"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", {
      id: `${uniqueId}-privilegesHeader`
    }, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.privileges.title', {
      defaultMessage: 'Security Privileges'
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.privileges.description', {
      defaultMessage: 'Control access to specific Elasticsearch APIs and resources using predefined roles or custom privileges per API key.'
    })))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: privilegesEnabled ? ENABLED_LABEL : DISABLED_LABEL,
      checked: privilegesEnabled,
      onChange: togglePrivileges,
      "data-test-subj": "create-api-role-descriptors-switch"
    }),
    forceState: privilegesOpen,
    onToggle: isOpen => {
      if (privilegesEnabled) {
        setPrivilegesOpen(isOpen ? 'open' : 'closed');
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_security_privileges_form.SecurityPrivilegesForm, {
    roleDescriptors: roleDescriptors,
    onChangeRoleDescriptors: setRoleDescriptors,
    error: roleDescriptorsError
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "apiKey.metadata",
    paddingSize: "l",
    role: "region",
    "aria-labelledby": `${uniqueId}-metadataHeader`,
    buttonContent: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        paddingRight: euiTheme.size.s
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visVega"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", {
      id: `${uniqueId}-metadataHeader`
    }, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.metadata.title', {
      defaultMessage: 'Metadata'
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.metadata.description', {
      defaultMessage: 'Use configurable key-value pairs to add information about the API key or customize Elasticsearch resource access.'
    })))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: metadataEnabled ? ENABLED_LABEL : DISABLED_LABEL,
      checked: metadataEnabled,
      onChange: toggleMetadata,
      "data-test-subj": "create-api-metadata-switch"
    }),
    forceState: metadataOpen,
    onToggle: isOpen => {
      if (metadataEnabled) {
        setMetadataOpen(isOpen ? 'open' : 'closed');
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_metadata_form.MetadataForm, {
    metadata: metadata,
    onChangeMetadata: setMetadata,
    error: metadataError
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isDisabled: isLoading,
    onClick: closeFlyOut,
    "data-test-subj": "create-api-key-cancel"
  }, CANCEL_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: !name,
    isLoading: isLoading,
    onClick: onCreateClick,
    "data-test-subj": "create-api-key-submit"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.flyOutCreateLabel', {
    defaultMessage: 'Create API Key'
  }))))))));
};
exports.CreateApiKeyFlyout = CreateApiKeyFlyout;