"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexNameLogic = void 0;
var _kea = require("kea");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexNameLogic = exports.IndexNameLogic = (0, _kea.kea)({
  actions: {
    setIndexName: indexName => ({
      indexName
    })
  },
  path: ['enterprise_search', 'content', 'index_name'],
  reducers: () => ({
    indexName: [
    // Short-circuiting this to empty string is necessary to enable testing logics relying on this
    '', {
      // @ts-expect-error upgrade typescript v5.1.6
      setIndexName: (_, {
        indexName
      }) => indexName
    }]
  })
});