"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSelectableOptions = exports.getCheckedOptionLabels = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSelectableOptions = (domain, showAllFields) => {
  const {
    availableDeduplicationFields,
    deduplicationFields,
    deduplicationEnabled
  } = domain;
  let selectableOptions;
  if (showAllFields) {
    selectableOptions = availableDeduplicationFields.map(field => ({
      label: field,
      checked: deduplicationFields.includes(field) ? 'on' : undefined
    }));
  } else {
    selectableOptions = availableDeduplicationFields.filter(field => deduplicationFields.includes(field)).map(field => ({
      label: field,
      checked: 'on'
    }));
  }
  if (!deduplicationEnabled) {
    selectableOptions = selectableOptions.map(option => ({
      ...option,
      disabled: true
    }));
  }
  return selectableOptions;
};
exports.getSelectableOptions = getSelectableOptions;
const getCheckedOptionLabels = options => {
  return options.filter(option => option.checked).map(option => option.label);
};
exports.getCheckedOptionLabels = getCheckedOptionLabels;