"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthenticationPanelViewContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _crawler_domain_detail_logic = require("../crawler_domain_detail_logic");
require("./authentication_panel.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AuthenticationPanelViewContent = () => {
  const {
    domain
  } = (0, _kea.useValues)(_crawler_domain_detail_logic.CrawlerDomainDetailLogic);
  return domain !== null && domain !== void 0 && domain.auth ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "none",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.authenticationPanel.configurationSavePanel.title', {
    defaultMessage: 'Configuration settings saved'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.authenticationPanel.configurationSavePanel.description', {
    defaultMessage: 'Authentication settings for crawling protected content have been saved. To update an authentication mechanism, delete settings and restart.'
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.authenticationPanel.emptyPrompt.title', {
      defaultMessage: 'No authentication configured'
    })),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.crawler.authenticationPanel.emptyPrompt.description",
      defaultMessage: "Click {addAuthenticationButtonLabel} to provide the credentials needed to crawl protected content",
      values: {
        addAuthenticationButtonLabel: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.authenticationPanel.emptyPrompt.addAuthenticationButtonLabel', {
          defaultMessage: 'Add authentication'
        }))
      }
    }),
    titleSize: "s"
  });
};
exports.AuthenticationPanelViewContent = AuthenticationPanelViewContent;