"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlDetailsFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _loading = require("../../../../../shared/loading");
var _crawl_detail_logic = require("./crawl_detail_logic");
var _crawl_details_preview = require("./crawl_details_preview");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlDetailsFlyout = () => {
  const {
    closeFlyout,
    setSelectedTab
  } = (0, _kea.useActions)(_crawl_detail_logic.CrawlDetailLogic);
  const {
    crawlRequestFromServer,
    dataLoading,
    flyoutClosed,
    selectedTab
  } = (0, _kea.useValues)(_crawl_detail_logic.CrawlDetailLogic);
  if (flyoutClosed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    maxWidth: "45rem",
    ownFocus: true,
    onClose: closeFlyout,
    "aria-labelledby": "CrawlDetailsFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "CrawlDetailsFlyoutTitle"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlDetailsFlyout.title', {
    defaultMessage: 'Crawl request details'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    style: {
      marginBottom: '-25px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === 'preview',
    onClick: () => setSelectedTab('preview')
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlDetailsFlyout.previewTabLabel', {
    defaultMessage: 'Preview'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === 'json',
    onClick: () => setSelectedTab('json')
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlDetailsFlyout.rawJSONTabLabel', {
    defaultMessage: 'Raw JSON'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, dataLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedTab === 'preview' && /*#__PURE__*/_react.default.createElement(_crawl_details_preview.CrawlDetailsPreview, null), selectedTab === 'json' && /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true
  }, JSON.stringify(crawlRequestFromServer, null, 2)))));
};
exports.CrawlDetailsFlyout = CrawlDetailsFlyout;