"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatCard = exports.ConnectorStats = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchConnectors = require("@kbn/search-connectors");
var _encode_path_params = require("../../../shared/encode_path_params");
var _kibana = require("../../../shared/kibana");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _routes = require("../../routes");
var _connector_status_helpers = require("../../utils/connector_status_helpers");
var _connector_detail = require("./connector_detail");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatCard = ({
  title,
  content,
  footer
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: false,
    hasBorder: true,
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, content))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued"
  }, footer));
};
exports.StatCard = StatCard;
const seeDocumentsLabel = _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.seeDocumentsTextLabel', {
  defaultMessage: 'See documents'
});
const pipelinesLabel = _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.managePipelines', {
  defaultMessage: 'Manage pipelines'
});
const configureLabel = _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.configureLink', {
  defaultMessage: 'Configure'
});
const ConnectorStats = ({
  connector,
  indexData
}) => {
  var _connectorDefinition$, _indexData$count;
  const {
    connectorTypes
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const CUSTOM_CONNECTOR = (0, _react.useMemo)(() => connectorTypes.filter(({
    serviceType
  }) => serviceType === ''), [connectorTypes]);
  const connectorDefinition = connectorTypes.find(c => c.serviceType === connector.service_type) || CUSTOM_CONNECTOR[0];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3,
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StatCard, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.h4.connectorLabel', {
      defaultMessage: 'Connector'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      responsive: false,
      alignItems: "center",
      justifyContent: "spaceBetween"
    }, connectorDefinition && connectorDefinition.iconPath && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: connectorDefinition.iconPath,
      size: "xl"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, (_connectorDefinition$ = connectorDefinition === null || connectorDefinition === void 0 ? void 0 : connectorDefinition.name) !== null && _connectorDefinition$ !== void 0 ? _connectorDefinition$ : '-'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: (0, _connector_status_helpers.connectorStatusToColor)(connector)
    }, (0, _connector_status_helpers.connectorStatusToText)(connector)))),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.connectors.connectorStats.connectorIdLabel",
      defaultMessage: "ID: {connectorId}",
      values: {
        connectorId: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, connector.id)
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: connector.id
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: copy,
      color: "text",
      iconType: "copyClipboard",
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.copyConnectorIdButton', {
        defaultMessage: 'Copy Connector ID'
      }),
      "data-test-subj": "copyConnectorIdButton"
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, [_searchConnectors.ConnectorStatus.CONNECTED, _searchConnectors.ConnectorStatus.CONFIGURED].includes(connector.status) && connector.index_name ? /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
      size: "s",
      to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
        connectorId: connector.id,
        tabId: _connector_detail.ConnectorDetailTabId.CONFIGURATION
      })
    }, configureLabel) : /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      color: "primary",
      size: "s",
      fill: true,
      to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
        connectorId: connector.id,
        tabId: _connector_detail.ConnectorDetailTabId.CONFIGURATION
      })
    }, configureLabel)))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StatCard, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.indexTitle', {
      defaultMessage: 'Attached index'
    }),
    content: connector.index_name ? indexData ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, connector.index_name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "success"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.conectors.indexHealth', {
      defaultMessage: 'Healthy'
    })))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "warning"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.indexDoesntExistLabel', {
      defaultMessage: "Index doesn't exist"
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "danger"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.noIndexLabel', {
      defaultMessage: 'No index attached yet'
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "documents"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.p.DocumentsLabel', {
      defaultMessage: '{documentAmount} Documents',
      values: {
        documentAmount: (_indexData$count = indexData === null || indexData === void 0 ? void 0 : indexData.count) !== null && _indexData$count !== void 0 ? _indexData$count : 0
      }
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
      isDisabled: !(connector.index_name && indexData),
      size: "s",
      to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
        connectorId: connector.id,
        tabId: _connector_detail.ConnectorDetailTabId.DOCUMENTS
      })
    }, seeDocumentsLabel)))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StatCard, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.pipelinesTitle', {
      defaultMessage: 'Pipelines'
    }),
    content: connector.pipeline ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, connector.pipeline.name))) : _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.noPipelineText', {
      defaultMessage: 'None'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
      isDisabled: !connector.index_name,
      size: "s",
      to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
        connectorId: connector.id,
        tabId: _connector_detail.ConnectorDetailTabId.PIPELINES
      })
    }, pipelinesLabel)))
  })));
};
exports.ConnectorStats = ConnectorStats;