"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCrawlerDomains = exports.GetCrawlerDomainsApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCrawlerDomains = async ({
  indexName,
  meta
}) => {
  const query = {
    'page[current]': meta.page.current,
    'page[size]': meta.page.size
  };
  const response = await _http.HttpLogic.values.http.get(`/internal/enterprise_search/indices/${indexName}/crawler/domains`, {
    query
  });
  return (0, _utils.crawlerDomainsWithMetaServerToClient)(response);
};
exports.getCrawlerDomains = getCrawlerDomains;
const GetCrawlerDomainsApiLogic = exports.GetCrawlerDomainsApiLogic = (0, _create_api_logic.createApiLogic)(['get_crawler_domains'], getCrawlerDomains);