"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationViewTabs = exports.SearchApplicationContentTabs = exports.SearchApplicationConnectTabs = exports.SEARCH_APPLICATION_TAB_PATH = exports.SEARCH_APPLICATION_PATH = exports.SEARCH_APPLICATION_CREATION_PATH = exports.SEARCH_APPLICATION_CONTENT_PATH = exports.SEARCH_APPLICATION_CONNECT_PATH = exports.SEARCH_APPLICATIONS_PATH = exports.ROOT_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ROOT_PATH = exports.ROOT_PATH = '/';
const SEARCH_APPLICATIONS_PATH = exports.SEARCH_APPLICATIONS_PATH = `${ROOT_PATH}search_applications`;
let SearchApplicationViewTabs = exports.SearchApplicationViewTabs = /*#__PURE__*/function (SearchApplicationViewTabs) {
  SearchApplicationViewTabs["DOCS_EXPLORER"] = "docs_explorer";
  SearchApplicationViewTabs["CONTENT"] = "content";
  SearchApplicationViewTabs["CONNECT"] = "connect";
  return SearchApplicationViewTabs;
}({});
const SEARCH_APPLICATION_CREATION_PATH = exports.SEARCH_APPLICATION_CREATION_PATH = `${SEARCH_APPLICATIONS_PATH}/new`;
const SEARCH_APPLICATION_PATH = exports.SEARCH_APPLICATION_PATH = `${SEARCH_APPLICATIONS_PATH}/:searchApplicationName`;
const SEARCH_APPLICATION_TAB_PATH = exports.SEARCH_APPLICATION_TAB_PATH = `${SEARCH_APPLICATION_PATH}/:tabId`;
const SEARCH_APPLICATION_CONNECT_PATH = exports.SEARCH_APPLICATION_CONNECT_PATH = `${SEARCH_APPLICATION_PATH}/${SearchApplicationViewTabs.CONNECT}/:connectTabId`;
let SearchApplicationConnectTabs = exports.SearchApplicationConnectTabs = /*#__PURE__*/function (SearchApplicationConnectTabs) {
  SearchApplicationConnectTabs["SEARCHAPI"] = "search_api";
  SearchApplicationConnectTabs["DOCUMENTATION"] = "documentation";
  return SearchApplicationConnectTabs;
}({});
const SEARCH_APPLICATION_CONTENT_PATH = exports.SEARCH_APPLICATION_CONTENT_PATH = `${SEARCH_APPLICATION_PATH}/${SearchApplicationViewTabs.CONTENT}/:contentTabId`;
let SearchApplicationContentTabs = exports.SearchApplicationContentTabs = /*#__PURE__*/function (SearchApplicationContentTabs) {
  SearchApplicationContentTabs["INDICES"] = "indices";
  SearchApplicationContentTabs["SCHEMA"] = "schema";
  return SearchApplicationContentTabs;
}({});