"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationNameLogic = void 0;
var _kea = require("kea");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchApplicationNameLogic = exports.SearchApplicationNameLogic = (0, _kea.kea)({
  actions: {
    setSearchApplicationName: name => ({
      name
    })
  },
  path: ['enterprise_search', 'search_applications', 'search_application_name'],
  reducers: ({
    props
  }) => {
    var _props$searchApplicat;
    return {
      searchApplicationName: [// Short-circuiting this to empty string is necessary to enable testing logics relying on this
      (_props$searchApplicat = props.searchApplicationName) !== null && _props$searchApplicat !== void 0 ? _props$searchApplicat : '', {
        // @ts-expect-error upgrade typescript v5.1.6
        setSearchApplicationName: (_, {
          name
        }) => name
      }]
    };
  }
});