"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupGuide = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _setup_guide = require("../../../shared/setup_guide");
var _telemetry = require("../../../shared/telemetry");
var _getting_started = _interopRequireDefault(require("./assets/getting_started.png"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SetupGuide = () => /*#__PURE__*/_react.default.createElement(_setup_guide.SetupGuideLayout, {
  productName: _constants.APP_SEARCH_PLUGIN.NAME,
  productEuiIcon: "logoAppSearch"
}, /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetAppSearchChrome, {
  trail: [_setup_guide.SETUP_GUIDE_TITLE]
}), /*#__PURE__*/_react.default.createElement(_telemetry.SendAppSearchTelemetry, {
  action: "viewed",
  metric: "setup_guide"
}), /*#__PURE__*/_react.default.createElement("a", {
  href: "https://www.elastic.co/webinars/getting-started-with-elastic-app-search",
  target: "_blank",
  rel: "noopener noreferrer"
}, /*#__PURE__*/_react.default.createElement("img", {
  className: "setupGuide__thumbnail",
  src: _getting_started.default,
  alt: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.setupGuide.videoAlt', {
    defaultMessage: "Getting started with App Search - in this short video we'll guide you through how to get App Search up and running"
  }),
  width: "1280",
  height: "720"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.appSearch.setupGuide.description",
  defaultMessage: "Get tools to design and deploy a powerful search to your websites and mobile applications."
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.appSearch.setupGuide.notConfigured",
  defaultMessage: "App Search is not configured in your Kibana instance yet."
}))));
exports.SetupGuide = SetupGuide;