"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchLogic = void 0;
var _kea = require("kea");
var _flash_messages = require("../../../shared/flash_messages");
var _http = require("../../../shared/http");
var _results = require("../../utils/results");
var _engine = require("../engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchLogic = exports.SearchLogic = (0, _kea.kea)({
  key: props => props.id,
  path: key => ['enterprise_search', 'app_search', 'search_logic', key],
  actions: () => ({
    search: query => ({
      query
    }),
    onSearch: ({
      results
    }) => ({
      results
    })
  }),
  reducers: () => ({
    searchDataLoading: [false, {
      search: () => true,
      onSearch: () => false
    }],
    searchQuery: ['', {
      // @ts-expect-error upgrade typescript v5.1.6
      search: (_, {
        query
      }) => query
    }],
    searchResults: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      onSearch: (_, {
        results
      }) => results.map(res => (0, _results.formatResult)(res))
    }]
  }),
  listeners: ({
    actions
  }) => ({
    search: async ({
      query
    }, breakpoint) => {
      await breakpoint(250);
      const {
        http
      } = _http.HttpLogic.values;
      const {
        engineName
      } = _engine.EngineLogic.values;
      try {
        const response = await http.post(`/internal/app_search/engines/${engineName}/search`, {
          query: {
            query
          }
        });
        actions.onSearch(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    }
  })
});