"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiInputRowsLogic = void 0;
var _kea = require("kea");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MultiInputRowsLogic = exports.MultiInputRowsLogic = (0, _kea.kea)({
  path: key => ['enterprise_search', 'app_search', 'multi_input_rows_logic', key],
  key: props => props.id,
  actions: () => ({
    addValue: true,
    deleteValue: indexToDelete => ({
      indexToDelete
    }),
    editValue: (index, newValueValue) => ({
      index,
      newValueValue
    })
  }),
  reducers: ({
    props
  }) => ({
    values: [props.values, {
      // @ts-expect-error upgrade typescript v5.1.6
      addValue: state => [...state, ''],
      // @ts-expect-error upgrade typescript v5.1.6
      deleteValue: (state, {
        indexToDelete
      }) => {
        const newState = [...state];
        newState.splice(indexToDelete, 1);
        return newState;
      },
      // @ts-expect-error upgrade typescript v5.1.6
      editValue: (state, {
        index,
        newValueValue
      }) => {
        const newState = [...state];
        newState[index] = newValueValue;
        return newState;
      }
    }],
    addedNewRow: [false, {
      addValue: () => true
    }]
  }),
  selectors: {
    hasEmptyValues: [selectors => [selectors.values], values => values.indexOf('') >= 0],
    hasOnlyOneValue: [selectors => [selectors.values], values => values.length <= 1]
  }
});