"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchExperienceContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _reactSearchUi = require("@elastic/react-search-ui");
var _i18n = require("@kbn/i18n");
var _loading = require("../../../../shared/loading");
var _engine = require("../../engine");
var _hooks = require("./hooks");
var _pagination = require("./pagination");
var _views = require("./views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchExperienceContent = () => {
  const {
    resultSearchTerm,
    totalResults,
    wasSearched
  } = (0, _hooks.useSearchContextState)();
  const {
    isMetaEngine,
    engine
  } = (0, _kea.useValues)(_engine.EngineLogic);
  if (!wasSearched) return /*#__PURE__*/_react.default.createElement(_loading.Loading, null);
  if (totalResults) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      "data-test-subj": "documentsSearchResults"
    }, /*#__PURE__*/_react.default.createElement(_pagination.Pagination, {
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.paging.ariaLabelTop', {
        defaultMessage: 'Search results paging at top of results'
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_reactSearchUi.Results, {
      titleField: "id",
      resultView: ({
        result
      }) => {
        return /*#__PURE__*/_react.default.createElement(_views.ResultView, {
          result: result,
          schemaForTypeHighlights: engine.schema,
          isMetaEngine: isMetaEngine
        });
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_pagination.Pagination, {
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.paging.ariaLabelBottom', {
        defaultMessage: 'Search results paging at bottom of results'
      })
    }));
  }

  // If we have no results, but have a search term, show a message
  if (resultSearchTerm) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "documentsSearchNoResults",
      body: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.noResults', {
        defaultMessage: 'No results for "{resultSearchTerm}" yet!',
        values: {
          resultSearchTerm
        }
      })
    });
  }
  return null;
};
exports.SearchExperienceContent = SearchExperienceContent;