"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutContent = exports.DocumentCreationFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var _creation_mode_components = require("./creation_mode_components");
var _creation_response_components = require("./creation_response_components");
var _types = require("./types");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentCreationFlyout = () => {
  const {
    closeDocumentCreation
  } = (0, _kea.useActions)(_.DocumentCreationLogic);
  const {
    isDocumentCreationOpen
  } = (0, _kea.useValues)(_.DocumentCreationLogic);
  return isDocumentCreationOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    "aria-labelledby": _constants.FLYOUT_ARIA_LABEL_ID,
    onClose: closeDocumentCreation
  }, /*#__PURE__*/_react.default.createElement(FlyoutContent, null))) : null;
};
exports.DocumentCreationFlyout = DocumentCreationFlyout;
const FlyoutContent = () => {
  const {
    creationStep,
    creationMode
  } = (0, _kea.useValues)(_.DocumentCreationLogic);
  switch (creationStep) {
    case _types.DocumentCreationStep.ShowCreationModes:
      return /*#__PURE__*/_react.default.createElement(_creation_mode_components.ShowCreationModes, null);
    case _types.DocumentCreationStep.AddDocuments:
      switch (creationMode) {
        case 'api':
          return /*#__PURE__*/_react.default.createElement(_creation_mode_components.ApiCodeExample, null);
        case 'json':
          return /*#__PURE__*/_react.default.createElement(_creation_mode_components.JsonFlyout, null);
        case 'elasticsearchIndex':
          return /*#__PURE__*/_react.default.createElement(_creation_mode_components.ElasticsearchIndex, null);
      }
    case _types.DocumentCreationStep.ShowSummary:
      return /*#__PURE__*/_react.default.createElement(_creation_response_components.Summary, null);
  }
};
exports.FlyoutContent = FlyoutContent;