"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurationSuggestion = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _icons = require("../../../../../shared/icons");
var _encode_path_params = require("../../../../utils/encode_path_params");
var _engine = require("../../../engine");
var _layout = require("../../../layout");
var _result = require("../../../result");
var _results = require("../../curation/results");
var _utils = require("../../utils");
var _curation_action_bar = require("./curation_action_bar");
var _curation_result_panel = require("./curation_result_panel");
var _curation_suggestion_logic = require("./curation_suggestion_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CurationSuggestion = () => {
  var _suggestion$curation;
  const {
    query
  } = (0, _encode_path_params.useDecodedParams)();
  const {
    engine,
    isMetaEngine
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const curationSuggestionLogic = (0, _curation_suggestion_logic.CurationSuggestionLogic)({
    query
  });
  const {
    loadSuggestion
  } = (0, _kea.useActions)(curationSuggestionLogic);
  const {
    suggestion,
    dataLoading
  } = (0, _kea.useValues)(curationSuggestionLogic);
  const [showOrganicResults, setShowOrganicResults] = (0, _react.useState)(false);
  const currentOrganicResults = (suggestion === null || suggestion === void 0 ? void 0 : (_suggestion$curation = suggestion.curation) === null || _suggestion$curation === void 0 ? void 0 : _suggestion$curation.organic) || [];
  const proposedOrganicResults = (suggestion === null || suggestion === void 0 ? void 0 : suggestion.organic) || [];
  const totalNumberOfOrganicResults = currentOrganicResults.length + proposedOrganicResults.length;
  const existingCurationResults = suggestion !== null && suggestion !== void 0 && suggestion.curation ? suggestion.curation.promoted.map(_results.convertToResultFormat) : [];
  const suggestedPromotedDocuments = suggestion !== null && suggestion !== void 0 && suggestion.promoted ? suggestion === null || suggestion === void 0 ? void 0 : suggestion.promoted.map(_results.convertToResultFormat) : [];
  const suggestionQuery = (suggestion === null || suggestion === void 0 ? void 0 : suggestion.query) || '';
  (0, _react.useEffect)(() => {
    loadSuggestion();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    isLoading: dataLoading,
    pageChrome: (0, _utils.getCurationsBreadcrumbs)([_i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.breadcrumbLabel', {
      defaultMessage: 'Suggested: {query}',
      values: {
        query: suggestionQuery
      }
    })]),
    pageHeader: {
      pageTitle: suggestionQuery
    }
  }, /*#__PURE__*/_react.default.createElement(_curation_action_bar.CurationActionBar, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.currentTitle', {
    defaultMessage: 'Current'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_curation_result_panel.CurationResultPanel, {
    variant: "current",
    results: existingCurationResults
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.suggestionTitle', {
    defaultMessage: 'Suggested'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_curation_result_panel.CurationResultPanel, {
    variant: "suggested",
    results: suggestedPromotedDocuments
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    size: "s",
    style: {
      width: '100%'
    },
    iconType: showOrganicResults ? 'fold' : 'unfold',
    iconSide: "right",
    onClick: () => setShowOrganicResults(!showOrganicResults),
    "data-test-subj": "showOrganicResults"
  }, showOrganicResults ? _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.collapseButtonLabel', {
    defaultMessage: 'Collapse organic search results'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.expandButtonLabel', {
    defaultMessage: 'Expand organic search results'
  })), showOrganicResults && totalNumberOfOrganicResults === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: _icons.LeafIcon,
    title: /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.noOrganicResultsTitle', {
      defaultMessage: 'No results'
    })),
    body: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.noOrganicResultsDescription', {
      defaultMessage: 'No organic search results were returned for this query'
    })
  }), showOrganicResults && totalNumberOfOrganicResults > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    "data-test-subj": "organicResults"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, currentOrganicResults.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "currentOrganicResults"
  }, currentOrganicResults.map((result, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: result.id.raw
  }, /*#__PURE__*/_react.default.createElement(_result.Result, {
    result: result,
    isMetaEngine: isMetaEngine,
    schemaForTypeHighlights: engine.schema,
    resultPosition: index + existingCurationResults.length + 1
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, proposedOrganicResults.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "proposedOrganicResults"
  }, proposedOrganicResults.map((result, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: result.id.raw
  }, /*#__PURE__*/_react.default.createElement(_result.Result, {
    result: result,
    isMetaEngine: isMetaEngine,
    schemaForTypeHighlights: engine.schema,
    resultPosition: index + suggestedPromotedDocuments.length + 1
  }))))))))));
};
exports.CurationSuggestion = CurationSuggestion;