"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInjectFunction = void 0;
var _migrate_base_input = require("./migrate_base_input");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getInjectFunction = embeddables => {
  return (state, references) => {
    var _embeddables$getEmbed;
    const enhancements = state.enhancements || {};
    const factory = (_embeddables$getEmbed = embeddables.getEmbeddableFactory) === null || _embeddables$getEmbed === void 0 ? void 0 : _embeddables$getEmbed.call(embeddables, state.type);
    let updatedInput = (0, _migrate_base_input.injectBaseEmbeddableInput)(state, references);
    if (factory) {
      updatedInput = factory.inject(updatedInput, references);
    }
    updatedInput.enhancements = {};
    Object.keys(enhancements).forEach(key => {
      if (!enhancements[key]) return;
      updatedInput.enhancements[key] = embeddables.getEnhancement(key).inject(enhancements[key], references);
    });
    return updatedInput;
  };
};
exports.getInjectFunction = getInjectFunction;