"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostEvaluateResponse = exports.PostEvaluateRequestBody = exports.PostEvaluateBody = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../conversations/common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Post Evaluate API endpoint
 *   version: 1
 */

const PostEvaluateBody = exports.PostEvaluateBody = _zod.z.object({
  graphs: _zod.z.array(_zod.z.string()),
  datasetName: _zod.z.string(),
  evaluatorConnectorId: _zod.z.string().optional(),
  connectorIds: _zod.z.array(_zod.z.string()),
  runName: _zod.z.string().optional(),
  alertsIndexPattern: _zod.z.string().optional().default('.alerts-security.alerts-default'),
  langSmithApiKey: _zod.z.string().optional(),
  langSmithProject: _zod.z.string().optional(),
  replacements: _common_attributes.Replacements.optional().default({}),
  size: _zod.z.number().optional().default(20)
});
const PostEvaluateRequestBody = exports.PostEvaluateRequestBody = PostEvaluateBody;
const PostEvaluateResponse = exports.PostEvaluateResponse = _zod.z.object({
  evaluationId: _zod.z.string(),
  success: _zod.z.boolean()
});