"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootContext = exports.MessageData = exports.ChatMessageRoleEnum = exports.ChatMessageRole = exports.ChatMessage = exports.ChatCompleteRequestBody = exports.ChatCompleteProps = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Chat Complete API endpoint
 *   version: 2023-10-31
 */

/**
 * The operational context for the assistant.
 */

const RootContext = exports.RootContext = _zod.z.literal('security');

/**
 * The role associated with the message in the chat.
 */

const ChatMessageRole = exports.ChatMessageRole = _zod.z.enum(['system', 'user', 'assistant']);
const ChatMessageRoleEnum = exports.ChatMessageRoleEnum = ChatMessageRole.enum;

/**
 * ECS-style metadata attached to the message.
 */

const MessageData = exports.MessageData = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * A message exchanged within the AI chat conversation.
 */

const ChatMessage = exports.ChatMessage = _zod.z.object({
  /**
   * The textual content of the message.
   */
  content: _zod.z.string().optional(),
  /**
   * The sender role of the message.
   */
  role: ChatMessageRole,
  /**
   * Metadata to attach to the context of the message.
   */
  data: MessageData.optional(),
  /**
   * List of field names within the data object that should be anonymized.
   */
  fields_to_anonymize: _zod.z.array(_zod.z.string()).optional()
});

/**
 * The request payload for creating a chat completion.
 */

const ChatCompleteProps = exports.ChatCompleteProps = _zod.z.object({
  /**
   * Existing conversation ID to continue.
   */
  conversationId: _common_attributes.NonEmptyString.optional(),
  /**
   * Prompt template identifier.
   */
  promptId: _zod.z.string().optional(),
  /**
   * If true, the response will be streamed in chunks.
   */
  isStream: _zod.z.boolean().optional(),
  /**
   * ISO language code for the assistant's response.
   */
  responseLanguage: _zod.z.string().optional(),
  /**
   * LangSmith project name for tracing.
   */
  langSmithProject: _zod.z.string().optional(),
  /**
   * API key for LangSmith integration.
   */
  langSmithApiKey: _zod.z.string().optional(),
  /**
   * Required connector identifier to route the request.
   */
  connectorId: _zod.z.string(),
  /**
   * Model ID or name to use for the response.
   */
  model: _zod.z.string().optional(),
  /**
   * Whether to persist the chat and response to storage.
   */
  persist: _zod.z.boolean(),
  /**
   * List of chat messages exchanged so far.
   */
  messages: _zod.z.array(ChatMessage)
});
const ChatCompleteRequestBody = exports.ChatCompleteRequestBody = ChatCompleteProps;