"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVERLESS_TYPE = exports.RUM_AGENT_NAMES = exports.OPEN_TELEMETRY_BASE_AGENT_NAMES = exports.OPEN_TELEMETRY_AGENT_NAMES = exports.JAVA_AGENT_NAMES = exports.IOS_AGENT_NAMES = exports.ELASTIC_AGENT_NAMES = exports.ANDROID_AGENT_NAMES = exports.AGENT_NAMES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * We cannot mark these arrays as const and derive their type
 * because we need to be able to assign them as mutable entities for ES queries.
 */

const ELASTIC_AGENT_NAMES = exports.ELASTIC_AGENT_NAMES = ['dotnet', 'go', 'iOS/swift', 'java', 'js-base', 'nodejs', 'php', 'python', 'ruby', 'rum-js', 'android/java'];
const OPEN_TELEMETRY_BASE_AGENT_NAMES = exports.OPEN_TELEMETRY_BASE_AGENT_NAMES = ['otlp', 'opentelemetry'];
const OPEN_TELEMETRY_AGENT_NAMES = exports.OPEN_TELEMETRY_AGENT_NAMES = [...OPEN_TELEMETRY_BASE_AGENT_NAMES, 'opentelemetry/cpp', 'opentelemetry/dotnet', 'opentelemetry/erlang', 'opentelemetry/go', 'opentelemetry/java', 'opentelemetry/nodejs', 'opentelemetry/php', 'opentelemetry/python', 'opentelemetry/ruby', 'opentelemetry/rust', 'opentelemetry/swift', 'opentelemetry/android', 'opentelemetry/webjs', 'otlp/cpp', 'otlp/dotnet', 'otlp/erlang', 'otlp/go', 'otlp/java', 'otlp/nodejs', 'otlp/php', 'otlp/python', 'otlp/ruby', 'otlp/rust', 'otlp/swift', 'otlp/android', 'otlp/webjs'];
const JAVA_AGENT_NAMES = exports.JAVA_AGENT_NAMES = ['java', 'opentelemetry/java', 'otlp/java'];
const RUM_AGENT_NAMES = exports.RUM_AGENT_NAMES = ['js-base', 'rum-js', 'opentelemetry/webjs', 'otlp/webjs'];
const ANDROID_AGENT_NAMES = exports.ANDROID_AGENT_NAMES = ['android/java', 'opentelemetry/android', 'otlp/android'];
const IOS_AGENT_NAMES = exports.IOS_AGENT_NAMES = ['ios/swift', 'opentelemetry/swift', 'otlp/swift'];
const SERVERLESS_TYPE = exports.SERVERLESS_TYPE = ['aws.lambda', 'azure.functions'];
const AGENT_NAMES = exports.AGENT_NAMES = [...ELASTIC_AGENT_NAMES, ...OPEN_TELEMETRY_AGENT_NAMES, ...JAVA_AGENT_NAMES, ...RUM_AGENT_NAMES, ...ANDROID_AGENT_NAMES, ...IOS_AGENT_NAMES];