"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewSavedSearchAction = exports.ACTION_VIEW_SAVED_SEARCH = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _get_discover_locator_params = require("../utils/get_discover_locator_params");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ACTION_VIEW_SAVED_SEARCH = exports.ACTION_VIEW_SAVED_SEARCH = 'ACTION_VIEW_SAVED_SEARCH';
class ViewSavedSearchAction {
  // Same order as ACTION_OPEN_IN_DISCOVER

  constructor(application, locator) {
    (0, _defineProperty2.default)(this, "id", ACTION_VIEW_SAVED_SEARCH);
    (0, _defineProperty2.default)(this, "type", ACTION_VIEW_SAVED_SEARCH);
    (0, _defineProperty2.default)(this, "order", 20);
    this.application = application;
    this.locator = locator;
  }
  async execute({
    embeddable
  }) {
    const {
      compatibilityCheck
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./view_saved_search_compatibility_check')));
    if (!compatibilityCheck(embeddable)) {
      return;
    }
    const locatorParams = (0, _get_discover_locator_params.getDiscoverLocatorParams)(embeddable);
    await this.locator.navigate(locatorParams);
  }
  getDisplayName() {
    return _i18n.i18n.translate('discover.savedSearchEmbeddable.action.viewSavedSearch.displayName', {
      defaultMessage: 'Open in Discover'
    });
  }
  getIconType() {
    return 'discoverApp';
  }
  async isCompatible({
    embeddable
  }) {
    const {
      capabilities
    } = this.application;
    const hasDiscoverPermissions = capabilities.discover.show || capabilities.discover.save;
    if (!hasDiscoverPermissions) return false; // early return to delay async import until absolutely necessary
    const {
      compatibilityCheck
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./view_saved_search_compatibility_check')));
    return compatibilityCheck(embeddable);
  }
}
exports.ViewSavedSearchAction = ViewSavedSearchAction;