"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createObservabilityRootProfileProvider = void 0;
var _profiles = require("../../../profiles");
var _consts = require("../consts");
var _accessors = require("./accessors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createObservabilityRootProfileProvider = services => ({
  profileId: _consts.OBSERVABILITY_ROOT_PROFILE_ID,
  profile: {
    getAppMenu: (0, _accessors.createGetAppMenu)(services),
    getDefaultAdHocDataViews: _accessors.getDefaultAdHocDataViews
  },
  resolve: params => {
    if (params.solutionNavId !== _profiles.SolutionType.Observability) {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        solutionType: _profiles.SolutionType.Observability,
        allLogsIndexPattern: services.logsContextService.getAllLogsIndexPattern()
      }
    };
  }
});
exports.createObservabilityRootProfileProvider = createObservabilityRootProfileProvider;