"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InternalStateProvider = void 0;
exports.getInternalStateContainer = getInternalStateContainer;
exports.useInternalStateSelector = exports.selectDataViewsForPicker = void 0;
var _uuid = require("uuid");
var _common = require("@kbn/kibana-utils-plugin/common");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const {
  Provider: InternalStateProvider,
  useSelector: useInternalStateSelector
} = (0, _common.createStateContainerReactHelpers)();
exports.useInternalStateSelector = useInternalStateSelector;
exports.InternalStateProvider = InternalStateProvider;
function getInternalStateContainer() {
  return (0, _common.createStateContainer)({
    dataView: undefined,
    isDataViewLoading: false,
    adHocDataViews: [],
    defaultProfileAdHocDataViewIds: [],
    savedDataViews: [],
    expandedDoc: undefined,
    customFilters: [],
    overriddenVisContextAfterInvalidation: undefined,
    resetDefaultProfileState: {
      resetId: '',
      columns: false,
      rowHeight: false,
      breakdownField: false
    },
    dataRequestParams: {}
  }, {
    setDataView: prevState => nextDataView => {
      var _prevState$dataView;
      return {
        ...prevState,
        dataView: nextDataView,
        expandedDoc: (nextDataView === null || nextDataView === void 0 ? void 0 : nextDataView.id) !== ((_prevState$dataView = prevState.dataView) === null || _prevState$dataView === void 0 ? void 0 : _prevState$dataView.id) ? undefined : prevState.expandedDoc
      };
    },
    setIsDataViewLoading: prevState => loading => ({
      ...prevState,
      isDataViewLoading: loading
    }),
    setIsESQLToDataViewTransitionModalVisible: prevState => isVisible => ({
      ...prevState,
      isESQLToDataViewTransitionModalVisible: isVisible
    }),
    setSavedDataViews: prevState => nextDataViewList => ({
      ...prevState,
      savedDataViews: nextDataViewList
    }),
    setAdHocDataViews: prevState => newAdHocDataViewList => ({
      ...prevState,
      adHocDataViews: newAdHocDataViewList
    }),
    setDefaultProfileAdHocDataViews: prevState => defaultProfileAdHocDataViews => {
      const adHocDataViews = prevState.adHocDataViews.filter(dataView => !prevState.defaultProfileAdHocDataViewIds.includes(dataView.id)).concat(defaultProfileAdHocDataViews);
      const defaultProfileAdHocDataViewIds = defaultProfileAdHocDataViews.map(dataView => dataView.id);
      return {
        ...prevState,
        adHocDataViews,
        defaultProfileAdHocDataViewIds
      };
    },
    appendAdHocDataViews: prevState => dataViewsAdHoc => {
      const newDataViews = Array.isArray(dataViewsAdHoc) ? dataViewsAdHoc : [dataViewsAdHoc];
      const existingDataViews = (0, _lodash.differenceBy)(prevState.adHocDataViews, newDataViews, 'id');
      return {
        ...prevState,
        adHocDataViews: existingDataViews.concat(newDataViews)
      };
    },
    replaceAdHocDataViewWithId: prevState => (prevId, newDataView) => {
      let defaultProfileAdHocDataViewIds = prevState.defaultProfileAdHocDataViewIds;
      if (defaultProfileAdHocDataViewIds.includes(prevId)) {
        defaultProfileAdHocDataViewIds = defaultProfileAdHocDataViewIds.map(id => id === prevId ? newDataView.id : id);
      }
      return {
        ...prevState,
        adHocDataViews: prevState.adHocDataViews.map(dataView => dataView.id === prevId ? newDataView : dataView),
        defaultProfileAdHocDataViewIds
      };
    },
    setExpandedDoc: prevState => expandedDoc => ({
      ...prevState,
      expandedDoc
    }),
    setCustomFilters: prevState => customFilters => ({
      ...prevState,
      customFilters
    }),
    setOverriddenVisContextAfterInvalidation: prevState => overriddenVisContextAfterInvalidation => ({
      ...prevState,
      overriddenVisContextAfterInvalidation
    }),
    resetOnSavedSearchChange: prevState => () => ({
      ...prevState,
      overriddenVisContextAfterInvalidation: undefined,
      expandedDoc: undefined
    }),
    setDataRequestParams: prevState => params => ({
      ...prevState,
      dataRequestParams: params
    }),
    setResetDefaultProfileState: prevState => resetDefaultProfileState => ({
      ...prevState,
      resetDefaultProfileState: {
        ...resetDefaultProfileState,
        resetId: (0, _uuid.v4)()
      }
    })
  }, {}, {
    freeze: state => state
  });
}
const selectDataViewsForPicker = ({
  savedDataViews,
  adHocDataViews: originalAdHocDataViews,
  defaultProfileAdHocDataViewIds
}) => {
  const managedDataViews = originalAdHocDataViews.filter(({
    id
  }) => id && defaultProfileAdHocDataViewIds.includes(id));
  const adHocDataViews = (0, _lodash.differenceBy)(originalAdHocDataViews, managedDataViews, 'id');
  return {
    savedDataViews,
    managedDataViews,
    adHocDataViews
  };
};
exports.selectDataViewsForPicker = selectDataViewsForPicker;