"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamSettings = getDataStreamSettings;
var _services = require("../../../services");
var _get_datastream_created_on = require("./get_datastream_created_on");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataStreamSettings({
  esClient,
  dataStream
}) {
  var _dataStreamInfo$_meta, _dataStreamInfo$_meta2, _dataStreamInfo$indic;
  const [createdOn, [dataStreamInfo], datasetUserPrivileges] = await Promise.all([(0, _get_datastream_created_on.getDataStreamCreatedOn)(esClient, dataStream), _services.dataStreamService.getMatchingDataStreams(esClient, dataStream), _services.datasetQualityPrivileges.getDatasetPrivileges(esClient, dataStream)]);
  const integration = dataStreamInfo === null || dataStreamInfo === void 0 ? void 0 : (_dataStreamInfo$_meta = dataStreamInfo._meta) === null || _dataStreamInfo$_meta === void 0 ? void 0 : (_dataStreamInfo$_meta2 = _dataStreamInfo$_meta.package) === null || _dataStreamInfo$_meta2 === void 0 ? void 0 : _dataStreamInfo$_meta2.name;
  const lastBackingIndex = dataStreamInfo === null || dataStreamInfo === void 0 ? void 0 : (_dataStreamInfo$indic = dataStreamInfo.indices) === null || _dataStreamInfo$indic === void 0 ? void 0 : _dataStreamInfo$indic.at(-1);
  const indexTemplate = dataStreamInfo === null || dataStreamInfo === void 0 ? void 0 : dataStreamInfo.template;
  return {
    createdOn,
    integration,
    datasetUserPrivileges,
    lastBackingIndexName: lastBackingIndex === null || lastBackingIndex === void 0 ? void 0 : lastBackingIndex.index_name,
    indexTemplate
  };
}