"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEmptyState = useEmptyState;
var _react = require("@xstate/react");
var _context = require("../components/dataset_quality/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useEmptyState() {
  const {
    service
  } = (0, _context.useDatasetQualityContext)();
  const canReadDataset = (0, _react.useSelector)(service, state => state.context.datasetUserPrivileges.canRead);
  return {
    canReadDataset
  };
}